/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthModule;
import org.apache.syncope.core.provisioning.api.data.AuthModuleDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthModuleDataBinderImpl
implements AuthModuleDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AuthModuleDataBinder.class);
    protected final EntityFactory entityFactory;

    public AuthModuleDataBinderImpl(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    protected void populateItems(AuthModuleTO authModuleTO, AuthModule authModule) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
        SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        authModuleTO.getItems().forEach(itemTO -> {
            if (itemTO == null) {
                LOG.error("Null {}", (Object)Item.class.getSimpleName());
                invalidMapping.getElements().add("Null " + Item.class.getSimpleName());
            } else if (itemTO.getIntAttrName() == null) {
                requiredValuesMissing.getElements().add("intAttrName");
                scce.addException(requiredValuesMissing);
            } else {
                if (!JexlUtils.isExpressionValid((String)(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition()))) {
                    SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                    invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
                    scce.addException(invalidMandatoryCondition);
                }
                Item item = new Item();
                item.setIntAttrName(itemTO.getIntAttrName());
                item.setExtAttrName(itemTO.getExtAttrName());
                item.setMandatoryCondition(itemTO.getMandatoryCondition());
                item.setConnObjectKey(itemTO.isConnObjectKey());
                item.setPassword(itemTO.isPassword());
                item.setPropagationJEXLTransformer(itemTO.getPropagationJEXLTransformer());
                item.setPullJEXLTransformer(itemTO.getPullJEXLTransformer());
                authModule.getItems().add(item);
            }
        });
        if (!invalidMapping.getElements().isEmpty()) {
            scce.addException(invalidMapping);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public AuthModule create(AuthModuleTO authModuleTO) {
        AuthModule authModule = (AuthModule)this.entityFactory.newEntity(AuthModule.class);
        authModule.setKey(authModuleTO.getKey());
        return this.update(authModule, authModuleTO);
    }

    public AuthModule update(AuthModule authModule, AuthModuleTO authModuleTO) {
        authModule.setDescription(authModuleTO.getDescription());
        authModule.setState(authModuleTO.getState());
        authModule.setOrder(authModuleTO.getOrder());
        authModule.setConf(authModuleTO.getConf());
        authModule.getItems().clear();
        this.populateItems(authModuleTO, authModule);
        return authModule;
    }

    protected void populateItems(AuthModule authModule, AuthModuleTO authModuleTO) {
        authModule.getItems().forEach(item -> {
            Item itemTO = new Item();
            itemTO.setIntAttrName(item.getIntAttrName());
            itemTO.setExtAttrName(item.getExtAttrName());
            itemTO.setMandatoryCondition(item.getMandatoryCondition());
            itemTO.setConnObjectKey(item.isConnObjectKey());
            itemTO.setPassword(item.isPassword());
            itemTO.setPropagationJEXLTransformer(item.getPropagationJEXLTransformer());
            itemTO.setPullJEXLTransformer(item.getPullJEXLTransformer());
            itemTO.setPurpose(MappingPurpose.NONE);
            authModuleTO.getItems().add(itemTO);
        });
    }

    public AuthModuleTO getAuthModuleTO(AuthModule authModule) {
        AuthModuleTO authModuleTO = new AuthModuleTO();
        authModuleTO.setKey(authModule.getKey());
        authModuleTO.setDescription(authModule.getDescription());
        authModuleTO.setState(authModule.getState());
        authModuleTO.setOrder(authModule.getOrder());
        authModuleTO.setConf(authModule.getConf());
        this.populateItems(authModule, authModuleTO);
        return authModuleTO;
    }
}

