/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.common.rest.api.service.PolicyService;

public class PolicyRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -1392090291817187902L;
    protected static final Comparator<PolicyTO> COMPARATOR = Comparator.comparing(PolicyTO::getName);

    public <T extends PolicyTO> T read(PolicyType type, String key) {
        PolicyTO policy = null;
        try {
            policy = this.getService(PolicyService.class).read(type, key);
        }
        catch (Exception e) {
            LOG.warn("No policy found for type {} and key {}", new Object[]{type, key, e});
        }
        return (T)policy;
    }

    public <T extends PolicyTO> List<T> list(PolicyType type) {
        try {
            return this.getService(PolicyService.class).list(type).stream().sorted(COMPARATOR).collect(Collectors.toList());
        }
        catch (Exception ignore) {
            LOG.debug("No policy found", (Throwable)ignore);
            return List.of();
        }
    }

    public <T extends PolicyTO> void create(PolicyType type, T policy) {
        this.getService(PolicyService.class).create(type, policy);
    }

    public <T extends PolicyTO> void update(PolicyType type, T policy) {
        this.getService(PolicyService.class).update(type, policy);
    }

    public void delete(PolicyType type, String key) {
        this.getService(PolicyService.class).delete(type, key);
    }
}

