/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.wizards.any.EntityWrapper;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

public class DynRealmWrapper
extends EntityWrapper<DynRealmTO> {
    private static final long serialVersionUID = 7226128615964284614L;
    private Map<String, List<SearchClause>> dynClauses;

    public DynRealmWrapper(DynRealmTO dynRealmTO) {
        super((EntityTO)dynRealmTO);
        this.getDynClauses();
    }

    public final Map<String, List<SearchClause>> getDynClauses() {
        if (this.dynClauses == null) {
            this.dynClauses = SearchUtils.getSearchClauses(((DynRealmTO)this.getInnerObject()).getDynMembershipConds());
        }
        return this.dynClauses;
    }

    public void setDynClauses(Map<String, List<SearchClause>> dynClauses) {
        this.dynClauses.clear();
        this.dynClauses.putAll(dynClauses);
    }

    public Map<String, String> getDynMembershipConds() {
        HashMap<String, String> res = new HashMap<String, String>();
        if (this.dynClauses != null && !this.dynClauses.isEmpty()) {
            this.dynClauses.entrySet().stream().filter(entry -> CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))).forEachOrdered(entry -> {
                UserFiqlSearchConditionBuilder builder = AnyTypeKind.USER.name().equals(entry.getKey()) ? SyncopeClient.getUserSearchConditionBuilder() : (AnyTypeKind.GROUP.name().equals(entry.getKey()) ? SyncopeClient.getGroupSearchConditionBuilder() : SyncopeClient.getAnyObjectSearchConditionBuilder((String)((String)entry.getKey())));
                String fiql = SearchUtils.buildFIQL((List)entry.getValue(), builder);
                if (fiql != null) {
                    res.put((String)entry.getKey(), fiql);
                }
            });
        }
        return res;
    }

    public DynRealmTO fillDynamicConditions() {
        ((DynRealmTO)this.getInnerObject()).getDynMembershipConds().clear();
        ((DynRealmTO)this.getInnerObject()).getDynMembershipConds().putAll(this.getDynMembershipConds());
        return (DynRealmTO)this.getInnerObject();
    }
}

