/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.credential.HttpBasedServiceCredential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedProxyingException;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.AbstractTicketValidationException;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UnsatisfiedAuthenticationContextTicketValidationException;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.AuthenticationContextValidationResult;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.UnauthorizedServiceTicketValidationException;
import org.apereo.cas.web.AbstractDelegateController;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractServiceValidateController
extends AbstractDelegateController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceValidateController.class);
    private final ServiceValidateConfigurationContext serviceValidateConfigurationContext;

    private static void verifyRegisteredServiceProperties(RegisteredService registeredService, Service service) {
        if (registeredService == null) {
            String msg = String.format("Service [%s] is not found in service registry.", service.getId());
            LOGGER.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not enabled in the CAS service registry.", service.getId());
            LOGGER.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }

    public ProxyGrantingTicket handleProxyGrantingTicketDelivery(String serviceTicketId, Credential credential) throws AuthenticationException, AbstractTicketException {
        ServiceTicket serviceTicket = (ServiceTicket)this.serviceValidateConfigurationContext.getTicketRegistry().getTicket(serviceTicketId, ServiceTicket.class);
        AuthenticationResult authenticationResult = this.serviceValidateConfigurationContext.getAuthenticationSystemSupport().finalizeAuthenticationTransaction(serviceTicket.getService(), new Credential[]{credential});
        ProxyGrantingTicket proxyGrantingTicketId = this.serviceValidateConfigurationContext.getCentralAuthenticationService().createProxyGrantingTicket(serviceTicketId, authenticationResult);
        LOGGER.debug("Generated proxy-granting ticket [{}] off of service ticket [{}] and credential [{}]", new Object[]{proxyGrantingTicketId.getId(), serviceTicketId, credential});
        return proxyGrantingTicketId;
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebApplicationService service = this.serviceValidateConfigurationContext.getArgumentExtractor().extractService(request);
        String serviceTicketId = Optional.ofNullable(service).map(WebApplicationService::getArtifactId).orElse(null);
        if (service == null || StringUtils.isBlank((CharSequence)serviceTicketId)) {
            LOGGER.warn("Could not identify service and/or service ticket for service: [{}]", (Object)service);
            return this.generateErrorView("INVALID_REQUEST", "", request, service);
        }
        try {
            this.prepareForTicketValidation(request, service, serviceTicketId);
            return this.handleTicketValidation(request, response, service, serviceTicketId);
        }
        catch (AbstractTicketValidationException e) {
            String code = e.getCode();
            String description = this.getTicketValidationErrorDescription(code, new Object[]{serviceTicketId, e.getService().getId(), service.getId()}, request);
            return this.generateErrorView(code, description, request, service);
        }
        catch (AbstractTicketException e) {
            String description = this.getTicketValidationErrorDescription(e.getCode(), new Object[]{serviceTicketId}, request);
            return this.generateErrorView(e.getCode(), description, request, service);
        }
        catch (UnauthorizedProxyingException e) {
            String description = this.getTicketValidationErrorDescription("UNAUTHORIZED_SERVICE_PROXY", new Object[]{service.getId()}, request);
            return this.generateErrorView("UNAUTHORIZED_SERVICE_PROXY", description, request, service);
        }
        catch (PrincipalException | UnauthorizedServiceException e) {
            return this.generateErrorView("UNAUTHORIZED_SERVICE", null, request, service);
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return this.generateErrorView("INVALID_REQUEST", "", request, service);
        }
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public void addValidationSpecification(CasProtocolValidationSpecification validationSpecification) {
        this.serviceValidateConfigurationContext.getValidationSpecifications().add(validationSpecification);
    }

    protected Credential getServiceCredentialsFromRequest(WebApplicationService service, HttpServletRequest request) {
        String pgtUrl = request.getParameter("pgtUrl");
        if (StringUtils.isNotBlank((CharSequence)pgtUrl)) {
            try {
                CasModelRegisteredService registeredService = (CasModelRegisteredService)this.serviceValidateConfigurationContext.getServicesManager().findServiceBy((Service)service, CasModelRegisteredService.class);
                AbstractServiceValidateController.verifyRegisteredServiceProperties((RegisteredService)registeredService, (Service)service);
                return new HttpBasedServiceCredential(new URL(pgtUrl), registeredService);
            }
            catch (Exception e) {
                LOGGER.error("Error constructing [{}]", (Object)"pgtUrl");
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
        }
        return null;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        if (this.serviceValidateConfigurationContext.getCasProperties().getSso().isRenewAuthnEnabled()) {
            binder.setRequiredFields(new String[]{"renew"});
        }
    }

    protected void prepareForTicketValidation(HttpServletRequest request, WebApplicationService service, String serviceTicketId) {
    }

    protected ModelAndView handleTicketValidation(HttpServletRequest request, HttpServletResponse response, WebApplicationService service, String serviceTicketId) {
        Assertion assertion;
        ProxyGrantingTicket proxyGrantingTicketId = null;
        Credential serviceCredential = this.getServiceCredentialsFromRequest(service, request);
        if (serviceCredential != null) {
            try {
                proxyGrantingTicketId = this.handleProxyGrantingTicketDelivery(serviceTicketId, serviceCredential);
            }
            catch (AuthenticationException e) {
                LOGGER.warn("Failed to authenticate service credential [{}]", (Object)serviceCredential);
                String description = this.getTicketValidationErrorDescription("INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()}, request);
                return this.generateErrorView("INVALID_PROXY_CALLBACK", description, request, service);
            }
            catch (InvalidTicketException e) {
                LOGGER.error("Failed to create proxy granting ticket due to an invalid ticket for [{}]", (Object)serviceCredential);
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                String description = this.getTicketValidationErrorDescription(e.getCode(), new Object[]{serviceTicketId}, request);
                return this.generateErrorView(e.getCode(), description, request, service);
            }
            catch (AbstractTicketException e) {
                LOGGER.error("Failed to create proxy granting ticket for [{}]", (Object)serviceCredential);
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                String description = this.getTicketValidationErrorDescription(e.getCode(), new Object[]{serviceCredential.getId()}, request);
                return this.generateErrorView(e.getCode(), description, request, service);
            }
        }
        if (!this.validateAssertion(request, serviceTicketId, assertion = this.validateServiceTicket(service, serviceTicketId), (Service)service)) {
            String description = this.getTicketValidationErrorDescription("INVALID_TICKET", new Object[]{serviceTicketId}, request);
            return this.generateErrorView("INVALID_TICKET", description, request, service);
        }
        AuthenticationContextValidationResult ctxResult = this.serviceValidateConfigurationContext.getRequestedContextValidator().validateAuthenticationContext(assertion, request, response);
        if (!ctxResult.isSuccess()) {
            throw new UnsatisfiedAuthenticationContextTicketValidationException((Service)assertion.getService());
        }
        String proxyIou = "";
        ProxyHandler proxyHandler = this.serviceValidateConfigurationContext.getProxyHandler();
        if (serviceCredential != null && proxyHandler != null && proxyHandler.canHandle(serviceCredential)) {
            CasModelRegisteredService registeredService = ((HttpBasedServiceCredential)serviceCredential).getService();
            boolean authorizedToReleaseProxyGrantingTicket = registeredService.getAttributeReleasePolicy().isAuthorizedToReleaseProxyGrantingTicket();
            if (!authorizedToReleaseProxyGrantingTicket) {
                LOGGER.debug("Service [{}] is not authorized to release the PGT directly, make a proxy callback", (Object)registeredService);
                proxyIou = this.handleProxyIouDelivery(serviceCredential, (TicketGrantingTicket)proxyGrantingTicketId);
                if (StringUtils.isEmpty((CharSequence)proxyIou)) {
                    String description = this.getTicketValidationErrorDescription("INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()}, request);
                    return this.generateErrorView("INVALID_PROXY_CALLBACK", description, request, service);
                }
            } else {
                LOGGER.debug("Service [{}] is authorized to release the PGT directly, skip the proxy callback", (Object)registeredService);
            }
        } else {
            LOGGER.debug("No service credentials specified, and/or the proxy handler [{}] cannot handle credentials", (Object)proxyHandler);
        }
        this.onSuccessfulValidation(serviceTicketId, assertion);
        LOGGER.debug("Successfully validated service ticket [{}] for service [{}]", (Object)serviceTicketId, (Object)service.getId());
        return this.generateSuccessView(assertion, proxyIou, service, request, ctxResult.getContextId(), (TicketGrantingTicket)proxyGrantingTicketId);
    }

    protected Assertion validateServiceTicket(WebApplicationService service, String serviceTicketId) {
        return this.serviceValidateConfigurationContext.getCentralAuthenticationService().validateServiceTicket(serviceTicketId, (Service)service);
    }

    protected void onSuccessfulValidation(String serviceTicketId, Assertion assertion) {
    }

    protected void enforceTicketValidationAuthorizationFor(HttpServletRequest request, Service service, Assertion assertion) {
        Collection authorizers = this.serviceValidateConfigurationContext.getValidationAuthorizers().getAuthorizers();
        for (ServiceTicketValidationAuthorizer a : authorizers) {
            try {
                a.authorize(request, service, assertion);
            }
            catch (Exception e) {
                throw new UnauthorizedServiceTicketValidationException(service);
            }
        }
    }

    protected Map<String, ?> augmentSuccessViewModelObjects(Assertion assertion) {
        return new HashMap(0);
    }

    private String handleProxyIouDelivery(Credential serviceCredential, TicketGrantingTicket proxyGrantingTicketId) {
        return this.serviceValidateConfigurationContext.getProxyHandler().handle(serviceCredential, proxyGrantingTicketId);
    }

    private boolean validateAssertion(HttpServletRequest request, String serviceTicketId, Assertion assertion, Service service) {
        for (CasProtocolValidationSpecification spec : this.serviceValidateConfigurationContext.getValidationSpecifications()) {
            spec.reset();
            ServletRequestDataBinder binder = new ServletRequestDataBinder((Object)spec, "validationSpecification");
            this.initBinder(request, binder);
            binder.bind((ServletRequest)request);
            if (spec.isSatisfiedBy(assertion, request)) continue;
            LOGGER.warn("Service ticket [{}] does not satisfy validation specification.", (Object)serviceTicketId);
            return false;
        }
        this.enforceTicketValidationAuthorizationFor(request, service, assertion);
        return true;
    }

    private ModelAndView generateErrorView(String code, String description, HttpServletRequest request, WebApplicationService service) {
        ModelAndView modelAndView = this.serviceValidateConfigurationContext.getValidationViewFactory().getModelAndView(request, false, service, ((Object)((Object)this)).getClass());
        modelAndView.addObject("code", (Object)StringEscapeUtils.escapeHtml4((String)code));
        modelAndView.addObject("description", (Object)StringEscapeUtils.escapeHtml4((String)description));
        return modelAndView;
    }

    private String getTicketValidationErrorDescription(String code, Object[] args, HttpServletRequest request) {
        return this.applicationContext.getMessage(code, args, code, request.getLocale());
    }

    private ModelAndView generateSuccessView(Assertion assertion, String proxyIou, WebApplicationService service, HttpServletRequest request, Optional<String> multifactorProvider, TicketGrantingTicket proxyGrantingTicket) {
        ModelAndView modelAndView = this.serviceValidateConfigurationContext.getValidationViewFactory().getModelAndView(request, true, service, ((Object)((Object)this)).getClass());
        modelAndView.addObject("assertion", (Object)assertion);
        modelAndView.addObject("service", (Object)service);
        if (StringUtils.isNotBlank((CharSequence)proxyIou)) {
            modelAndView.addObject("pgtIou", (Object)proxyIou);
        }
        if (proxyGrantingTicket != null) {
            modelAndView.addObject("proxyGrantingTicket", (Object)proxyGrantingTicket.getId());
        }
        multifactorProvider.ifPresent(provider -> modelAndView.addObject(this.serviceValidateConfigurationContext.getCasProperties().getAuthn().getMfa().getCore().getAuthenticationContextAttribute(), provider));
        Map<String, ?> augmentedModelObjects = this.augmentSuccessViewModelObjects(assertion);
        modelAndView.addAllObjects(augmentedModelObjects);
        return modelAndView;
    }

    @Generated
    public ServiceValidateConfigurationContext getServiceValidateConfigurationContext() {
        return this.serviceValidateConfigurationContext;
    }

    @Generated
    protected AbstractServiceValidateController(ServiceValidateConfigurationContext serviceValidateConfigurationContext) {
        this.serviceValidateConfigurationContext = serviceValidateConfigurationContext;
    }
}

