/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;

public final class AuthenticatorDataFlags {
    public final byte value;
    public final boolean UP;
    public final boolean UV;
    public final boolean AT;
    public final boolean ED;

    @JsonCreator
    public AuthenticatorDataFlags(@JsonProperty(value="value") byte value) {
        this.value = value;
        this.UP = (value & 1) != 0;
        this.UV = (value & 4) != 0;
        this.AT = (value & 0x40) != 0;
        this.ED = (value & 0xFFFFFF80) != 0;
    }

    @Generated
    public String toString() {
        return "AuthenticatorDataFlags(value=" + this.value + ", UP=" + this.UP + ", UV=" + this.UV + ", AT=" + this.AT + ", ED=" + this.ED + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorDataFlags)) {
            return false;
        }
        AuthenticatorDataFlags other = (AuthenticatorDataFlags)o;
        if (this.value != other.value) {
            return false;
        }
        if (this.UP != other.UP) {
            return false;
        }
        if (this.UV != other.UV) {
            return false;
        }
        if (this.AT != other.AT) {
            return false;
        }
        return this.ED == other.ED;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.value;
        result = result * 59 + (this.UP ? 79 : 97);
        result = result * 59 + (this.UV ? 79 : 97);
        result = result * 59 + (this.AT ? 79 : 97);
        result = result * 59 + (this.ED ? 79 : 97);
        return result;
    }

    private static final class Bitmasks {
        static final byte UP = 1;
        static final byte UV = 4;
        static final byte AT = 64;
        static final byte ED = -128;

        private Bitmasks() {
        }
    }
}

