/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.directory.Directory;
import com.google.api.services.directory.model.Member;
import com.google.api.services.directory.model.Members;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.tirasa.connid.bundles.googleapps.GoogleApiExecutor;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import net.tirasa.connid.bundles.googleapps.RequestResultHandler;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Uid;

public final class MembersHandler {
    private static final Log LOG = Log.getLog(MembersHandler.class);

    public static ObjectClassInfo getObjectClassInfo() {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.setType(GoogleAppsUtil.MEMBER.getObjectClassValue());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)Name.NAME).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"groupKey").setUpdateable(false).setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"email").setUpdateable(false).setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"role"));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"type").setUpdateable(false).setCreateable(false).build());
        return builder.build();
    }

    public static Directory.Members.Insert create(Directory.Members service, AttributesAccessor attributes) {
        String groupKey = attributes.findString("groupKey");
        if (StringUtil.isBlank((String)groupKey)) {
            throw new InvalidAttributeValueException("Missing required attribute 'groupKey'. Identifies the group in the API request. Required when creating a Member.");
        }
        String memberKey = attributes.findString("email");
        if (StringUtil.isBlank((String)memberKey)) {
            throw new InvalidAttributeValueException("Missing required attribute 'memberKey'. Identifies the group member in the API request. Required when creating a Member.");
        }
        String role = attributes.findString("role");
        return MembersHandler.create(service, groupKey, memberKey, role);
    }

    public static Directory.Members.Insert create(Directory.Members service, String groupKey, Uid uid, String role) {
        Member content = new Member();
        content.setId(uid.getUidValue());
        if (StringUtil.isBlank((String)role)) {
            content.setRole("MEMBER");
        } else {
            content.setRole(role);
        }
        try {
            return service.insert(groupKey, content).setFields("email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Members.Insert create(Directory.Members service, String groupKey, String email, String role) {
        Member content = new Member();
        content.setEmail(email);
        if (StringUtil.isBlank((String)role)) {
            content.setRole("MEMBER");
        } else {
            content.setRole(role);
        }
        try {
            return service.insert(groupKey, content).setFields("email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Members.Patch update(Directory.Members service, String groupKey, String memberKey, String role) {
        Member content = new Member();
        content.setEmail(memberKey);
        if (StringUtil.isBlank((String)role)) {
            content.setRole("MEMBER");
        } else {
            content.setRole(role);
        }
        try {
            return service.patch(groupKey, memberKey, content).setFields("email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Update", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Members.Delete delete(Directory.Members service, String groupKey, String memberKey) {
        try {
            return service.delete(groupKey, memberKey);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static ConnectorObject from(String groupKey, Member content) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(GoogleAppsUtil.MEMBER);
        Uid uid = MembersHandler.generateUid(groupKey, content);
        builder.setUid(uid);
        builder.setName(uid.getUidValue());
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"groupKey", (Object[])new Object[]{content.getId()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"email", (Object[])new Object[]{content.getEmail()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"role", (Object[])new Object[]{content.getRole()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"type", (Object[])new Object[]{content.getType()})});
        return builder.build();
    }

    public static Uid generateUid(String groupKey, Member content) {
        String memberName = groupKey + '/' + content.getEmail();
        Uid uid = null != content.getEtag() ? new Uid(memberName, content.getEtag()) : new Uid(memberName);
        return uid;
    }

    public static List<Map<String, String>> listMembers(Directory.Members service, String groupKey, String roles) {
        final ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            String nextPageToken;
            Directory.Members.List request = service.list(groupKey);
            request.setRoles(StringUtil.isBlank((String)roles) ? "OWNER,MANAGER,MEMBER" : roles);
            while (StringUtil.isNotBlank((String)(nextPageToken = GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Members.List, Members, String>(){

                @Override
                public String handleResult(Directory.Members.List request, Members value) {
                    if (null != value.getMembers()) {
                        for (Member member : value.getMembers()) {
                            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>(2);
                            m.put("email", member.getEmail());
                            m.put("role", member.getRole());
                            result.add(m);
                        }
                    }
                    return value.getNextPageToken();
                }
            })))) {
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        return result;
    }

    private MembersHandler() {
    }
}

