/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.principal;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalAuditPrincipalResolver
implements PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadLocalAuditPrincipalResolver.class);
    private final AuditPrincipalIdProvider auditPrincipalIdProvider;

    public String resolveFrom(JoinPoint auditTarget, Object returnValue) {
        LOGGER.trace("Resolving principal at audit point [{}]", (Object)auditTarget);
        return this.getCurrentPrincipal(auditTarget, returnValue, null);
    }

    public String resolveFrom(JoinPoint auditTarget, Exception exception) {
        LOGGER.trace("Resolving principal at audit point [{}] with thrown exception [{}]", (Object)auditTarget, (Object)exception);
        return this.getCurrentPrincipal(auditTarget, null, exception);
    }

    public String resolve() {
        return "audit:unknown";
    }

    private String getCurrentPrincipal(JoinPoint auditTarget, Object returnValue, Exception exception) {
        Authentication authn = AuthenticationCredentialsThreadLocalBinder.getCurrentAuthentication();
        String principal = this.auditPrincipalIdProvider.getPrincipalIdFrom(auditTarget, authn, returnValue, exception);
        String id = (String)FunctionUtils.doIfNull((Object)principal, AuthenticationCredentialsThreadLocalBinder::getCurrentCredentialIdsAsString, () -> principal).get();
        if (id == null && returnValue instanceof AuditableExecutionResult) {
            AuditableExecutionResult auditResult = (AuditableExecutionResult)returnValue;
            id = auditResult.getAuthentication().map(Authentication::getPrincipal).map(Principal::getId).orElse(null);
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)"audit:unknown");
    }

    @Generated
    public ThreadLocalAuditPrincipalResolver(AuditPrincipalIdProvider auditPrincipalIdProvider) {
        this.auditPrincipalIdProvider = auditPrincipalIdProvider;
    }
}

