/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.deployer;

import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.InboundChannelModelCacheManager;
import org.flowable.eventregistry.api.InboundEventChannelAdapter;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.deployer.ParsedDeployment;
import org.flowable.eventregistry.impl.persistence.deploy.ChannelDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.deploy.EventDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.deploy.EventDeploymentManager;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventregistry.json.converter.EventJsonConverter;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.model.OutboundChannelModel;

public class CachingAndArtifactsManager {
    public void removeChannelDefinitionFromCache(String channelDefinitionId) {
        EventRegistryEngineConfiguration eventRegistryEngineConfiguration = CommandContextUtil.getEventRegistryConfiguration();
        DeploymentCache<ChannelDefinitionCacheEntry> channelDefinitionCache = eventRegistryEngineConfiguration.getDeploymentManager().getChannelDefinitionCache();
        channelDefinitionCache.remove(channelDefinitionId);
    }

    public void updateCachingAndArtifacts(ParsedDeployment parsedDeployment) {
        EventRegistryEngineConfiguration eventRegistryEngineConfiguration = CommandContextUtil.getEventRegistryConfiguration();
        DeploymentCache<EventDefinitionCacheEntry> eventDefinitionCache = eventRegistryEngineConfiguration.getDeploymentManager().getEventDefinitionCache();
        EventDeploymentEntity deployment = parsedDeployment.getDeployment();
        EventJsonConverter eventJsonConverter = eventRegistryEngineConfiguration.getEventJsonConverter();
        for (EventDefinitionEntity eventDefinition : parsedDeployment.getAllEventDefinitions()) {
            EventModel eventModel = parsedDeployment.getEventModelForEventDefinition(eventDefinition);
            EventDefinitionCacheEntry cacheEntry = new EventDefinitionCacheEntry(eventDefinition, eventJsonConverter.convertToJson(eventModel));
            eventDefinitionCache.add(eventDefinition.getId(), (Object)cacheEntry);
            deployment.addDeployedArtifact(eventDefinition);
        }
        DeploymentCache<ChannelDefinitionCacheEntry> channelDefinitionCache = eventRegistryEngineConfiguration.getDeploymentManager().getChannelDefinitionCache();
        for (ChannelDefinitionEntity channelDefinition : parsedDeployment.getAllChannelDefinitions()) {
            ChannelModel channelModel = parsedDeployment.getChannelModelForChannelDefinition(channelDefinition);
            ChannelDefinitionCacheEntry cacheEntry = new ChannelDefinitionCacheEntry(channelDefinition, channelModel);
            channelDefinitionCache.add(channelDefinition.getId(), (Object)cacheEntry);
            this.registerChannelModel(channelModel, channelDefinition, eventRegistryEngineConfiguration);
            deployment.addDeployedArtifact(channelDefinition);
        }
    }

    public void registerChannelModel(ChannelModel channelModel, ChannelDefinition channelDefinition, EventRegistryEngineConfiguration eventRegistryEngineConfiguration) {
        String channelDefinitionKey = channelModel.getKey();
        if (StringUtils.isEmpty((CharSequence)channelDefinitionKey)) {
            throw new FlowableIllegalArgumentException("No key set for channel model");
        }
        if (channelModel instanceof InboundChannelModel) {
            InboundChannelModel inboundChannelModel = (InboundChannelModel)channelModel;
            if (inboundChannelModel.getInboundEventChannelAdapter() != null) {
                InboundEventChannelAdapter inboundEventChannelAdapter = (InboundEventChannelAdapter)inboundChannelModel.getInboundEventChannelAdapter();
                inboundEventChannelAdapter.setEventRegistry(eventRegistryEngineConfiguration.getEventRegistry());
                inboundEventChannelAdapter.setInboundChannelModel(inboundChannelModel);
            }
        } else if (!(channelModel instanceof OutboundChannelModel)) {
            throw new FlowableIllegalArgumentException("Unrecognized ChannelModel class : " + channelModel.getClass());
        }
        InboundChannelModelCacheManager.ChannelRegistration channelRegistration = null;
        if (channelModel instanceof InboundChannelModel) {
            channelRegistration = eventRegistryEngineConfiguration.getInboundChannelModelCacheManager().registerChannelModel((InboundChannelModel)channelModel, channelDefinition);
        }
        boolean channelRegistered = channelRegistration == null || channelRegistration.registered();
        for (ChannelModelProcessor channelDefinitionProcessor : eventRegistryEngineConfiguration.getChannelModelProcessors()) {
            boolean canProcessChannel = channelRegistered ? channelDefinitionProcessor.canProcess(channelModel) : channelDefinitionProcessor.canProcessIfChannelModelAlreadyRegistered(channelModel);
            if (!canProcessChannel) continue;
            channelDefinitionProcessor.unregisterChannelModel(channelModel, channelDefinition.getTenantId(), eventRegistryEngineConfiguration.getEventRepositoryService());
            try {
                channelDefinitionProcessor.registerChannelModel(channelModel, channelDefinition.getTenantId(), eventRegistryEngineConfiguration.getEventRegistry(), eventRegistryEngineConfiguration.getEventRepositoryService(), eventRegistryEngineConfiguration.isFallbackToDefaultTenant());
            }
            catch (RuntimeException ex) {
                if (channelRegistration != null) {
                    ChannelDefinitionEntity previousChannelDefinition;
                    EventDeploymentManager deploymentManager;
                    ChannelDefinitionCacheEntry cacheEntry;
                    ChannelModel previousChannelModel;
                    channelRegistration.rollback();
                    InboundChannelModelCacheManager.RegisteredChannel previousChannel = channelRegistration.previousChannel();
                    if (previousChannel != null && (previousChannelModel = (cacheEntry = (deploymentManager = eventRegistryEngineConfiguration.getDeploymentManager()).resolveChannelDefinition(previousChannelDefinition = deploymentManager.findDeployedChannelDefinitionById(previousChannel.getChannelDefinitionId()))).getChannelModel()) instanceof InboundChannelModel) {
                        channelDefinitionProcessor.registerChannelModel(previousChannelModel, previousChannelDefinition.getTenantId(), eventRegistryEngineConfiguration.getEventRegistry(), eventRegistryEngineConfiguration.getEventRepositoryService(), eventRegistryEngineConfiguration.isFallbackToDefaultTenant());
                    }
                }
                throw ex;
            }
        }
    }
}

