/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.create.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.ForceOption;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.TemporaryOption;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;

public class CreateView
implements Statement {
    private Table view;
    private Select select;
    private boolean orReplace = false;
    private List<String> columnNames = null;
    private boolean materialized = false;
    private ForceOption force = ForceOption.NONE;
    private TemporaryOption temp = TemporaryOption.NONE;
    private boolean withReadOnly = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getView() {
        return this.view;
    }

    public void setView(Table table) {
        this.view = table;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public void setOrReplace(boolean bl2) {
        this.orReplace = bl2;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> list) {
        this.columnNames = list;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public void setMaterialized(boolean bl2) {
        this.materialized = bl2;
    }

    public ForceOption getForce() {
        return this.force;
    }

    public void setForce(ForceOption forceOption) {
        this.force = forceOption;
    }

    public TemporaryOption getTemporary() {
        return this.temp;
    }

    public void setTemporary(TemporaryOption temporaryOption) {
        this.temp = temporaryOption;
    }

    public boolean isWithReadOnly() {
        return this.withReadOnly;
    }

    public void setWithReadOnly(boolean bl2) {
        this.withReadOnly = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        if (this.isOrReplace()) {
            stringBuilder.append("OR REPLACE ");
        }
        switch (this.force) {
            case FORCE: {
                stringBuilder.append("FORCE ");
                break;
            }
            case NO_FORCE: {
                stringBuilder.append("NO FORCE ");
            }
        }
        if (this.temp != TemporaryOption.NONE) {
            stringBuilder.append(this.temp.name()).append(" ");
        }
        if (this.isMaterialized()) {
            stringBuilder.append("MATERIALIZED ");
        }
        stringBuilder.append("VIEW ");
        stringBuilder.append(this.view);
        if (this.columnNames != null) {
            stringBuilder.append(PlainSelect.getStringList(this.columnNames, true, true));
        }
        stringBuilder.append(" AS ").append(this.select);
        if (this.isWithReadOnly()) {
            stringBuilder.append(" WITH READ ONLY");
        }
        return stringBuilder.toString();
    }

    public CreateView withView(Table table) {
        this.setView(table);
        return this;
    }

    public CreateView withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public CreateView withOrReplace(boolean bl2) {
        this.setOrReplace(bl2);
        return this;
    }

    public CreateView withColumnNames(List<String> list) {
        this.setColumnNames(list);
        return this;
    }

    public CreateView withMaterialized(boolean bl2) {
        this.setMaterialized(bl2);
        return this;
    }

    public CreateView withForce(ForceOption forceOption) {
        this.setForce(forceOption);
        return this;
    }

    public CreateView withWithReadOnly(boolean bl2) {
        this.setWithReadOnly(bl2);
        return this;
    }

    public CreateView addColumnNames(String ... stringArray) {
        List list = Optional.ofNullable(this.getColumnNames()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withColumnNames(list);
    }

    public CreateView addColumnNames(Collection<String> collection) {
        List list = Optional.ofNullable(this.getColumnNames()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumnNames(list);
    }
}

