/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.supplier.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.change.ChangeFactory;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.core.HsqlDatabase;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;

public class ResourceSupplier {
    private static final ResourceAccessor RESOURCE_ACCESSOR = new SimpleResourceAccessor();
    private static final String USERS_CSV = "username, fullname, pk_id\nnvoxland, Nathan Voxland, 1\nbob, Bob Bobson, 2";
    private static final String EXAMPLE_SQL_COMMAND = "select * from person";

    public ResourceAccessor getSimpleResourceAccessor() {
        return RESOURCE_ACCESSOR;
    }

    private static class SimpleResourceAccessor
    extends AbstractResourceAccessor {
        private SimpleResourceAccessor() {
        }

        @Override
        public InputStreamList openStreams(String relativeTo, String streamPath) throws IOException {
            ByteArrayInputStream stream = null;
            String encoding = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
            if (streamPath.toLowerCase().endsWith("csv")) {
                stream = new ByteArrayInputStream(ResourceSupplier.USERS_CSV.getBytes(encoding));
            } else if (streamPath.toLowerCase().endsWith("my-logic.sql")) {
                stream = new ByteArrayInputStream(((String)Scope.getCurrentScope().getSingleton(ChangeFactory.class).getChangeMetaData(new CreateProcedureChange()).getParameters().get("procedureBody").getExampleValue(new HsqlDatabase())).getBytes(encoding));
            } else if (streamPath.toLowerCase().endsWith("sql")) {
                stream = new ByteArrayInputStream(ResourceSupplier.EXAMPLE_SQL_COMMAND.getBytes(encoding));
            } else {
                throw new RuntimeException("Unknown resource type: " + streamPath);
            }
            InputStreamList list = new InputStreamList();
            list.add(null, stream);
            return list;
        }

        @Override
        public SortedSet<String> list(String relativeTo, String path, boolean recursive, boolean includeFiles, boolean includeDirectories) throws IOException {
            return null;
        }

        @Override
        public SortedSet<String> describeLocations() {
            return new TreeSet<String>(Arrays.asList("Logic in ResourceSupplier.java"));
        }
    }
}

