/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.impl.BatchQueryImpl;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchEntityImpl;
import org.flowable.batch.service.impl.persistence.entity.data.BatchDataManager;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.db.AbstractDataManager;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;

public class MybatisBatchDataManager
extends AbstractDataManager<BatchEntity>
implements BatchDataManager {
    protected BatchServiceConfiguration batchServiceConfiguration;

    public MybatisBatchDataManager(BatchServiceConfiguration batchServiceConfiguration) {
        this.batchServiceConfiguration = batchServiceConfiguration;
    }

    public Class<? extends BatchEntity> getManagedEntityClass() {
        return BatchEntityImpl.class;
    }

    public BatchEntity create() {
        return new BatchEntityImpl();
    }

    @Override
    public List<Batch> findBatchesBySearchKey(String searchKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("searchKey", searchKey);
        params.put("searchKey2", searchKey);
        return this.getDbSqlSession().selectList("selectBatchesBySearchKey", params);
    }

    @Override
    public List<Batch> findAllBatches() {
        return this.getDbSqlSession().selectList("selectAllBatches");
    }

    @Override
    public List<Batch> findBatchesByQueryCriteria(BatchQueryImpl batchQuery) {
        return this.getDbSqlSession().selectList("selectBatchByQueryCriteria", (ListQueryParameterObject)batchQuery, this.getManagedEntityClass());
    }

    @Override
    public long findBatchCountByQueryCriteria(BatchQueryImpl batchQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectBatchCountByQueryCriteria", (Object)batchQuery);
    }

    @Override
    public void deleteBatches(BatchQueryImpl batchQuery) {
        this.getDbSqlSession().delete("bulkDeleteBytesForBatches", (Object)batchQuery, this.getManagedEntityClass());
        this.getDbSqlSession().delete("bulkDeleteBatchPartsForBatches", (Object)batchQuery, this.getManagedEntityClass());
        this.getDbSqlSession().delete("bulkDeleteBatches", (Object)batchQuery, this.getManagedEntityClass());
    }

    protected IdGenerator getIdGenerator() {
        return this.batchServiceConfiguration.getIdGenerator();
    }
}

