/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MailCommand
extends SmtpCommand {
    static final Pattern PARAM = Pattern.compile("MAIL FROM:\\s?<([^>]*)>.*", 2);

    @Override
    public void execute(SmtpConnection conn, SmtpState state, SmtpManager manager, String commandLine) {
        Matcher m = PARAM.matcher(commandLine);
        if (m.matches()) {
            String from = m.group(1);
            if (!from.isEmpty()) {
                MailAddress fromAddr = new MailAddress(from);
                String err = manager.checkSender(state, fromAddr);
                if (err != null) {
                    conn.send(err);
                    return;
                }
                state.clearMessagePreservingAuthenticationState();
                state.getMessage().setReturnPath(fromAddr);
                conn.send("250 OK");
            } else {
                state.clearMessagePreservingAuthenticationState();
                state.getMessage();
                conn.send("250 OK");
            }
        } else {
            conn.send("501 Required syntax: 'MAIL FROM:<email@host>'");
        }
    }
}

