/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.trusted.origin;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.role.Scope;
import com.okta.sdk.resource.trusted.origin.TrustedOrigin;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultTrustedOrigin
extends AbstractInstanceResource<TrustedOrigin>
implements TrustedOrigin {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty createdByProperty = new StringProperty("createdBy");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty lastUpdatedByProperty = new StringProperty("lastUpdatedBy");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final StringProperty originProperty = new StringProperty("origin");
    private static final ResourceListProperty<Scope> scopesProperty = new ResourceListProperty<Scope>("scopes", Scope.class);
    private static final StringProperty statusProperty = new StringProperty("status");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultTrustedOrigin.createPropertyDescriptorMap(linksProperty, createdProperty, createdByProperty, idProperty, lastUpdatedProperty, lastUpdatedByProperty, nameProperty, originProperty, scopesProperty, statusProperty);

    public DefaultTrustedOrigin(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultTrustedOrigin(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return TrustedOrigin.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getCreatedBy() {
        return this.getString(createdByProperty);
    }

    public TrustedOrigin setCreatedBy(String createdBy) {
        this.setProperty(createdByProperty, (Object)createdBy);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getLastUpdatedBy() {
        return this.getString(lastUpdatedByProperty);
    }

    public TrustedOrigin setLastUpdatedBy(String lastUpdatedBy) {
        this.setProperty(lastUpdatedByProperty, (Object)lastUpdatedBy);
        return this;
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public TrustedOrigin setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public String getOrigin() {
        return this.getString(originProperty);
    }

    public TrustedOrigin setOrigin(String origin) {
        this.setProperty(originProperty, (Object)origin);
        return this;
    }

    public List<Scope> getScopes() {
        return this.getResourceListProperty(scopesProperty);
    }

    public TrustedOrigin setScopes(List<Scope> scopes) {
        this.setProperty(scopesProperty, scopes);
        return this;
    }

    public String getStatus() {
        return this.getString(statusProperty);
    }

    public TrustedOrigin setStatus(String status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public TrustedOrigin update() {
        String trustedOriginId = this.getId();
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/trustedOrigins/" + trustedOriginId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    @Override
    public void delete() {
        String trustedOriginId = this.getId();
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/trustedOrigins/" + trustedOriginId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }
}

