/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config;

import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.config.Configuration;
import org.opensaml.core.config.ConfigurationPropertiesSource;
import org.opensaml.core.config.provider.MapBasedConfiguration;
import org.opensaml.core.config.provider.SystemPropertyConfigurationPropertiesSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService {
    @Nonnull
    public static final String DEFAULT_PARTITION_NAME = "default";
    @Nonnull
    public static final String PROPERTY_PARTITION_NAME = "opensaml.config.partitionName";
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationService.class);
    private static ServiceLoader<ConfigurationPropertiesSource> configPropertiesLoader = ServiceLoader.load(ConfigurationPropertiesSource.class);
    private static Configuration configuration;

    protected ConfigurationService() {
    }

    public static <T> T get(@Nonnull Class<T> configClass) {
        String partitionName = ConfigurationService.getPartitionName();
        return ConfigurationService.getConfiguration().get(configClass, partitionName);
    }

    public static <T, I extends T> void register(@Nonnull Class<T> configClass, @Nonnull I configInstance) {
        String partitionName = ConfigurationService.getPartitionName();
        ConfigurationService.getConfiguration().register(configClass, configInstance, partitionName);
    }

    public static <T> T deregister(@Nonnull Class<T> configClass) {
        String partitionName = ConfigurationService.getPartitionName();
        return ConfigurationService.getConfiguration().deregister(configClass, partitionName);
    }

    @Nullable
    public static Properties getConfigurationProperties() {
        LOG.trace("Resolving configuration propreties source");
        Iterator<ConfigurationPropertiesSource> iter = configPropertiesLoader.iterator();
        if (!iter.hasNext()) {
            LOG.trace("No ConfigurationPropertiesSources are configured, defaulting to system properties");
            return new SystemPropertyConfigurationPropertiesSource().getProperties();
        }
        while (iter.hasNext()) {
            ConfigurationPropertiesSource source = iter.next();
            LOG.trace("Evaluating configuration properties implementation: {}", (Object)source.getClass().getName());
            Properties props = source.getProperties();
            if (props == null) continue;
            LOG.trace("Resolved non-null configuration properties using implementation: {}", (Object)source.getClass().getName());
            return props;
        }
        LOG.trace("Unable to resolve non-null configuration properties from any ConfigurationPropertiesSource");
        return null;
    }

    public static void setConfiguration(@Nonnull Configuration newConfiguration) {
        configuration = (Configuration)Constraint.isNotNull((Object)newConfiguration, (String)"Configuration cannot be null");
    }

    @Nonnull
    @NotEmpty
    protected static String getPartitionName() {
        Properties configProperties = ConfigurationService.getConfigurationProperties();
        String partitionName = null;
        partitionName = configProperties != null ? configProperties.getProperty(PROPERTY_PARTITION_NAME, DEFAULT_PARTITION_NAME) : DEFAULT_PARTITION_NAME;
        LOG.trace("Resolved effective configuration partition name '{}'", (Object)partitionName);
        return partitionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    protected static Configuration getConfiguration() {
        if (configuration != null) return configuration;
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            ServiceLoader<Configuration> loader = ServiceLoader.load(Configuration.class);
            Iterator<Configuration> iter = loader.iterator();
            configuration = iter.hasNext() ? iter.next() : new MapBasedConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configuration;
        }
    }
}

