/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow.fingerprint;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintComponentManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoLocationDeviceFingerprintComponentManager
implements DeviceFingerprintComponentManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoLocationDeviceFingerprintComponentManager.class);
    private final GeoLocationService geoLocationService;
    private int order = Integer.MAX_VALUE;

    @Override
    public Optional<String> extractComponent(String principal, HttpServletRequest request, HttpServletResponse response) {
        GeoLocationRequest loc = WebUtils.getHttpServletRequestGeoLocation((HttpServletRequest)request);
        if (loc != null && loc.isValid()) {
            LOGGER.trace("Attempting to geolocate [{}]", (Object)loc);
            GeoLocationResponse geoResponse = this.geoLocationService.locate(loc);
            String address = geoResponse.build();
            if (StringUtils.isBlank((CharSequence)address)) {
                return GeoLocationDeviceFingerprintComponentManager.getDefaultGeoLocation(loc);
            }
            return Optional.of(address);
        }
        LOGGER.trace("No geolocation could be determined from the request");
        return Optional.empty();
    }

    private static Optional<String> getDefaultGeoLocation(GeoLocationRequest loc) {
        return Optional.of(loc.getLatitude() + "-" + loc.getLongitude());
    }

    @Generated
    public GeoLocationService getGeoLocationService() {
        return this.geoLocationService;
    }

    @Override
    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public GeoLocationDeviceFingerprintComponentManager(GeoLocationService geoLocationService) {
        this.geoLocationService = geoLocationService;
    }
}

