/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.session.ForceEagerSessionCreationFilter;

public final class SecurityContextConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<SecurityContextConfigurer<H>, H> {
    private boolean requireExplicitSave;

    public SecurityContextConfigurer<H> securityContextRepository(SecurityContextRepository securityContextRepository) {
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(SecurityContextRepository.class, securityContextRepository);
        return this;
    }

    public SecurityContextConfigurer<H> requireExplicitSave(boolean requireExplicitSave) {
        this.requireExplicitSave = requireExplicitSave;
        return this;
    }

    boolean isRequireExplicitSave() {
        return this.requireExplicitSave;
    }

    SecurityContextRepository getSecurityContextRepository() {
        SecurityContextRepository securityContextRepository = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(SecurityContextRepository.class);
        if (securityContextRepository == null) {
            securityContextRepository = new HttpSessionSecurityContextRepository();
        }
        return securityContextRepository;
    }

    @Override
    public void configure(H http) {
        SecurityContextRepository securityContextRepository = this.getSecurityContextRepository();
        if (this.requireExplicitSave) {
            SecurityContextHolderFilter securityContextHolderFilter = this.postProcess(new SecurityContextHolderFilter(securityContextRepository));
            securityContextHolderFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
            http.addFilter((Filter)securityContextHolderFilter);
        } else {
            SessionCreationPolicy sessionCreationPolicy;
            SecurityContextPersistenceFilter securityContextFilter = new SecurityContextPersistenceFilter(securityContextRepository);
            securityContextFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
            SessionManagementConfigurer sessionManagement = http.getConfigurer(SessionManagementConfigurer.class);
            SessionCreationPolicy sessionCreationPolicy2 = sessionCreationPolicy = sessionManagement != null ? sessionManagement.getSessionCreationPolicy() : null;
            if (SessionCreationPolicy.ALWAYS == sessionCreationPolicy) {
                securityContextFilter.setForceEagerSessionCreation(true);
                http.addFilter((Filter)this.postProcess(new ForceEagerSessionCreationFilter()));
            }
            securityContextFilter = this.postProcess(securityContextFilter);
            http.addFilter((Filter)securityContextFilter);
        }
    }
}

