/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.NameUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public final class AttributeUtil {
    private AttributeUtil() {
    }

    public static String getStringValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (String)obj;
    }

    public static Character getCharacterValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (Character)obj;
    }

    public static GuardedByteArray getGuardedByteArrayValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (GuardedByteArray)obj;
    }

    public static GuardedString getGuardedStringValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (GuardedString)obj;
    }

    public static String getAsStringValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : obj.toString();
    }

    public static Byte getByteValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (Byte)obj;
    }

    public static Byte[] getByteArrayValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        if (obj instanceof byte[]) {
            Byte[] copy = new Byte[((byte[])obj).length];
            for (int idx = 0; idx < ((byte[])obj).length; ++idx) {
                copy[idx] = ((byte[])obj)[idx];
            }
            return copy;
        }
        return obj == null ? null : (Byte[])obj;
    }

    public static Integer getIntegerValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (Integer)obj;
    }

    public static Long getLongValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (Long)obj;
    }

    public static Float getFloatValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (Float)obj;
    }

    public static Date getDateValue(Attribute attr) {
        Long value = AttributeUtil.getLongValue(attr);
        return value == null ? null : new Date(value);
    }

    public static Double getDoubleValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj != null ? (Double)obj : null;
    }

    public static BigDecimal getBigDecimalValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (BigDecimal)obj;
    }

    public static BigInteger getBigIntegerValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (BigInteger)obj;
    }

    public static Boolean getBooleanValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (Boolean)obj;
    }

    public static Map<String, Object> getMapValue(Attribute attr) {
        Object obj = AttributeUtil.getSingleValue(attr);
        return obj == null ? null : (Map)obj;
    }

    public static Object getSingleValue(Attribute attr) {
        Object ret = null;
        List<Object> val = attr.getValue();
        if (val != null && !val.isEmpty()) {
            if (val.size() > 1) {
                StringBuilder msg = new StringBuilder("The ").append(attr.getName()).append(" attribute is not single value attribute.");
                throw new IllegalArgumentException(msg.toString());
            }
            ret = val.get(0);
        }
        return ret;
    }

    public static Map<String, Attribute> toMap(Collection<? extends Attribute> attributes) {
        SortedMap ret = CollectionUtil.newCaseInsensitiveMap();
        for (Attribute attribute : attributes) {
            ret.put(attribute.getName(), attribute);
        }
        return CollectionUtil.asReadOnlyMap(ret);
    }

    public static Uid getUidAttribute(Set<Attribute> attrs) {
        return (Uid)AttributeUtil.find(Uid.NAME, attrs);
    }

    public static Set<Attribute> getBasicAttributes(Set<Attribute> attrs) {
        HashSet<Attribute> ret = new HashSet<Attribute>();
        for (Attribute attr : attrs) {
            if (AttributeUtil.isSpecial(attr)) continue;
            ret.add(attr);
        }
        return ret;
    }

    public static Set<Attribute> getSpecialAttributes(Set<Attribute> attrs) {
        HashSet<Attribute> ret = new HashSet<Attribute>();
        for (Attribute attr : attrs) {
            if (!AttributeUtil.isSpecial(attr)) continue;
            ret.add(attr);
        }
        return ret;
    }

    public static Set<Attribute> filterUid(Set<Attribute> attrs) {
        Assertions.nullCheck(attrs, "attrs");
        HashSet<Attribute> ret = new HashSet<Attribute>();
        for (Attribute attr : attrs) {
            if (attr instanceof Uid) continue;
            ret.add(attr);
        }
        return ret;
    }

    public static Set<Attribute> addUid(Set<Attribute> attrs, Uid uid) {
        Assertions.nullCheck(attrs, "attrs");
        Assertions.nullCheck(uid, "uid");
        HashSet<Attribute> ret = new HashSet<Attribute>(attrs);
        ret.add(uid);
        return ret;
    }

    public static boolean isSpecial(Attribute attr) {
        return AttributeUtil.isSpecialName(attr.getName());
    }

    public static boolean isSpecial(AttributeInfo attr) {
        String name = attr.getName();
        return AttributeUtil.isSpecialName(name);
    }

    public static boolean isSpecialName(String name) {
        return NameUtil.isSpecialName(name);
    }

    public static String createSpecialName(String name) {
        return NameUtil.createSpecialName(name);
    }

    public static boolean namesEqual(String name1, String name2) {
        return NameUtil.namesEqual(name1, name2);
    }

    public static Name getNameFromAttributes(Set<Attribute> attrs) {
        return (Name)AttributeUtil.find(Name.NAME, attrs);
    }

    public static Attribute find(String name, Set<Attribute> attrs) {
        Assertions.nullCheck(name, "name");
        Set<Attribute> set = CollectionUtil.nullAsEmpty(attrs);
        for (Attribute attr : set) {
            if (!attr.is(name)) continue;
            return attr;
        }
        return null;
    }

    public static GuardedString getPasswordValue(Set<Attribute> attrs) {
        Attribute pwd = AttributeUtil.find(OperationalAttributes.PASSWORD_NAME, attrs);
        return pwd == null ? null : AttributeUtil.getGuardedStringValue(pwd);
    }

    public static GuardedString getCurrentPasswordValue(Set<Attribute> attrs) {
        Attribute pwd = AttributeUtil.find(OperationalAttributes.CURRENT_PASSWORD_NAME, attrs);
        return pwd == null ? null : AttributeUtil.getGuardedStringValue(pwd);
    }

    public static Boolean isLockedOut(ConnectorObject obj) {
        Attribute attr = obj.getAttributeByName(OperationalAttributes.LOCK_OUT_NAME);
        return attr == null ? null : AttributeUtil.getBooleanValue(attr);
    }

    public static Boolean isEnabled(ConnectorObject obj) {
        Attribute attr = obj.getAttributeByName(OperationalAttributes.ENABLE_NAME);
        return attr == null ? null : AttributeUtil.getBooleanValue(attr);
    }

    public static Date getPasswordExpirationDate(ConnectorObject obj) {
        Attribute attr = obj.getAttributeByName(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME);
        return attr == null ? null : new Date(AttributeUtil.getLongValue(attr));
    }

    public static Boolean getPasswordExpired(Set<Attribute> attrs) {
        Attribute pwd = AttributeUtil.find(OperationalAttributes.PASSWORD_EXPIRED_NAME, attrs);
        return pwd == null ? null : AttributeUtil.getBooleanValue(pwd);
    }

    public static Boolean isPasswordExpired(ConnectorObject obj) {
        Attribute pwd = obj.getAttributeByName(OperationalAttributes.PASSWORD_EXPIRED_NAME);
        return pwd == null ? null : AttributeUtil.getBooleanValue(pwd);
    }

    public static Date getEnableDate(Set<Attribute> attrs) {
        Attribute date = AttributeUtil.find(OperationalAttributes.ENABLE_DATE_NAME, attrs);
        return date == null ? null : AttributeUtil.getDateValue(date);
    }
}

