/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.MappingTool;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Bootstrap;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.util.UserException;

public class JDBCBrokerFactory
extends AbstractBrokerFactory {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(JDBCBrokerFactory.class);
    private boolean _synchronizedMappings = false;

    public static JDBCBrokerFactory newInstance(ConfigurationProvider cp) {
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        cp.setInto((Configuration)conf);
        return new JDBCBrokerFactory(conf);
    }

    public static JDBCBrokerFactory getInstance(ConfigurationProvider cp, ClassLoader loader) {
        Map props = cp.getProperties();
        Object key = JDBCBrokerFactory.toPoolKey((Map)props);
        JDBCBrokerFactory factory = (JDBCBrokerFactory)JDBCBrokerFactory.getPooledFactoryForKey((Object)key);
        if (factory != null) {
            return factory;
        }
        factory = (JDBCBrokerFactory)Bootstrap.newBrokerFactory((ConfigurationProvider)cp, (ClassLoader)loader);
        JDBCBrokerFactory.pool((Object)key, (AbstractBrokerFactory)factory);
        return factory;
    }

    public JDBCBrokerFactory(JDBCConfiguration conf) {
        super((OpenJPAConfiguration)conf);
    }

    public Map<String, Object> getProperties() {
        Map props = super.getProperties();
        String db = "Unknown";
        try {
            JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
            db = conf.getDBDictionaryInstance().platform;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        props.put("Platform", "OpenJPA JDBC Edition: " + db + " Database");
        return props;
    }

    public void postCreationCallback() {
        super.postCreationCallback();
    }

    protected StoreManager newStoreManager() {
        return new JDBCStoreManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BrokerImpl newBrokerImpl(String user, String pass) {
        BrokerImpl broker = super.newBrokerImpl(user, pass);
        this.lock();
        try {
            if (!this._synchronizedMappings) {
                this._synchronizedMappings = true;
                this.synchronizeMappings(broker.getClassLoader());
            }
            BrokerImpl brokerImpl = broker;
            return brokerImpl;
        }
        finally {
            this.unlock();
        }
    }

    protected boolean synchronizeMappings(ClassLoader loader, JDBCConfiguration conf) {
        this.mapSchemaGenerationToSynchronizeMappings(conf);
        String action = conf.getSynchronizeMappings();
        if (StringUtil.isEmpty((String)action)) {
            return false;
        }
        MappingRepository repo = conf.getMappingRepositoryInstance();
        Collection classes = repo.loadPersistentTypes(false, loader);
        if (classes.isEmpty()) {
            return false;
        }
        String props = Configurations.getProperties((String)action);
        action = Configurations.getClassName((String)action);
        MappingTool tool = new MappingTool(conf, action, false, loader);
        Configurations.configureInstance((Object)tool, (Configuration)conf, (String)props, (String)"SynchronizeMappings");
        for (Class cls : classes) {
            try {
                tool.run(cls);
            }
            catch (IllegalArgumentException iae) {
                throw new UserException(_loc.get("bad-synch-mappings", (Object)action, Arrays.asList(MappingTool.ACTIONS)));
            }
        }
        tool.record();
        return true;
    }

    protected boolean synchronizeMappings(ClassLoader loader) {
        return this.synchronizeMappings(loader, (JDBCConfiguration)this.getConfiguration());
    }

    private void mapSchemaGenerationToSynchronizeMappings(JDBCConfiguration conf) {
        String loadFile;
        String actions = "";
        if (conf.getDatabaseAction() != null) {
            int databaseAction = conf.getDatabaseActionConstant();
            if (databaseAction == 1) {
                actions = this.generateSchemaCreation(conf);
            } else if (databaseAction == 3) {
                actions = this.generateSchemaDrop(conf);
            } else if (databaseAction == 2) {
                actions = this.generateSchemaDropCreate(conf);
            }
        }
        if ((loadFile = conf.getLoadScriptSource()) != null) {
            actions = actions + ",scriptLoad";
        }
        if (actions.length() > 0) {
            conf.setSynchronizeMappings("buildSchema(ForeignKeys=true,SchemaAction='" + actions + "')");
        }
    }

    private String generateSchemaCreation(JDBCConfiguration conf) {
        if (conf.getCreateScriptTarget() != null) {
            return "build";
        }
        int createSource = conf.getCreateSourceConstant();
        createSource = createSource == 0 && conf.getCreateScriptSource() != null ? 2 : 1;
        return this.mapGenerationStrategyActions(createSource, "add", "scriptCreate");
    }

    private String generateSchemaDrop(JDBCConfiguration conf) {
        if (conf.getDropScriptTarget() != null) {
            return "drop";
        }
        int dropSource = conf.getDropSourceConstant();
        dropSource = dropSource == 0 && conf.getDropScriptSource() != null ? 2 : 1;
        return this.mapGenerationStrategyActions(dropSource, "drop", "scriptDrop");
    }

    private String generateSchemaDropCreate(JDBCConfiguration conf) {
        if (conf.getCreateScriptTarget() != null && conf.getDropScriptTarget() != null) {
            return "build,drop";
        }
        return this.mapGenerationStrategyActions(conf.getDropSourceConstant(), "drop", "scriptDrop") + "," + this.mapGenerationStrategyActions(conf.getCreateSourceConstant(), "add", "scriptCreate");
    }

    private String mapGenerationStrategyActions(int source, String metadataAction, String scriptAction) {
        String actions = "";
        actions = source == 1 ? actions + metadataAction : (source == 2 ? actions + scriptAction : (source == 3 ? actions + metadataAction + "," + scriptAction : (source == 4 ? actions + scriptAction + "," + metadataAction : actions + metadataAction)));
        return actions;
    }
}

