/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.EmbedValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.kernel.ObjectIdStateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.InternalException;

public class ObjectIdValueHandler
extends EmbedValueHandler {
    private static final long serialVersionUID = 1L;
    private Object[] _args = null;

    @Override
    @Deprecated
    public Column[] map(ValueMapping vm, String name, ColumnIO io, boolean adapt) {
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn(name, dict != null ? dict.delimitAll() : false);
        return this.map(vm, colName, io, adapt);
    }

    public Column[] map(ValueMapping vm, DBIdentifier name, ColumnIO io, boolean adapt) {
        ArrayList cols = new ArrayList();
        ArrayList args = new ArrayList();
        this.setMapsIdCol(vm);
        super.map(vm, name, io, adapt, cols, args);
        vm.setColumns(cols.toArray(new Column[cols.size()]));
        this._args = args.toArray();
        return vm.getColumns();
    }

    private void setMapsIdCol(ValueMapping vm) {
        FieldMapping[] fmds;
        if (!(vm instanceof FieldMapping)) {
            return;
        }
        if (!((FieldMapping)vm).hasMapsIdCols()) {
            return;
        }
        ClassMapping embeddedMeta = (ClassMapping)((FieldMapping)vm).getValue().getEmbeddedMetaData();
        if (embeddedMeta == null) {
            return;
        }
        List<Column> mapsIdColList = ((FieldMapping)vm).getValueInfo().getMapsIdColumns();
        if (mapsIdColList.size() > 0) {
            this.setMapsIdCols(mapsIdColList, embeddedMeta);
            return;
        }
        for (FieldMapping fmd : fmds = embeddedMeta.getFieldMappings()) {
            mapsIdColList = fmd.getValueInfo().getMapsIdColumns();
            if (mapsIdColList.size() == 0) continue;
            ClassMapping embeddedMeta1 = (ClassMapping)fmd.getEmbeddedMetaData();
            if (embeddedMeta1 != null) {
                this.setMapsIdCols(mapsIdColList, embeddedMeta1);
                continue;
            }
            this.setMapsIdCols(mapsIdColList, fmd);
        }
    }

    private void setMapsIdCols(List cols, ClassMapping cm) {
        for (Object col : cols) {
            DBIdentifier refColName = ((Column)col).getTargetIdentifier();
            FieldMapping fm = this.getReferenceField(cm, refColName);
            if (fm == null) continue;
            ArrayList<Column> colList1 = new ArrayList<Column>();
            colList1.add((Column)col);
            fm.setMapsIdCols(true);
            fm.getValueInfo().setMapsIdColumns(colList1);
        }
    }

    private void setMapsIdCols(List cols, FieldMapping fm) {
        if (cols.size() == 1) {
            fm.setMapsIdCols(true);
            fm.getValueInfo().setMapsIdColumns(cols);
            return;
        }
        for (Object col : cols) {
            DBIdentifier refColName = ((Column)col).getTargetIdentifier();
            if (!this.isReferenceField(fm, refColName)) continue;
            ArrayList<Column> colList1 = new ArrayList<Column>();
            colList1.add((Column)col);
            fm.setMapsIdCols(true);
            fm.getValueInfo().setMapsIdColumns(colList1);
        }
    }

    private FieldMapping getReferenceField(ClassMapping cm, DBIdentifier refColName) {
        FieldMapping[] fmds;
        for (FieldMapping fmd : fmds = cm.getFieldMappings()) {
            if (!this.isReferenceField(fmd, refColName)) continue;
            return fmd;
        }
        return null;
    }

    private boolean isReferenceField(FieldMapping fm, DBIdentifier refColName) {
        List<Column> cols = fm.getValueInfo().getColumns();
        return cols.size() == 0 ? fm.getName().equals(refColName.getName()) : cols.get(0).getIdentifier().equals(refColName);
    }

    @Override
    public Object getResultArgument(ValueMapping vm) {
        return this._args;
    }

    @Override
    public Object toDataStoreValue(ValueMapping vm, Object val, JDBCStore store) {
        ObjectIdStateManager sm = val == null ? null : new ObjectIdStateManager(val, null, (ValueMetaData)vm);
        Column[] cols = vm.getColumns();
        Object[] rval = null;
        if (cols.length > 1) {
            rval = new Object[cols.length];
        }
        return super.toDataStoreValue((OpenJPAStateManager)sm, vm, store, cols, rval, 0);
    }

    @Override
    public Object toObjectValue(ValueMapping vm, Object val) {
        if (val == null) {
            return null;
        }
        ObjectIdStateManager sm = new ObjectIdStateManager(null, null, (ValueMetaData)vm);
        try {
            super.toObjectValue((OpenJPAStateManager)sm, vm, val, null, null, vm.getColumns(), 0);
        }
        catch (SQLException se) {
            throw new InternalException((Throwable)se);
        }
        return sm.getManagedInstance();
    }
}

