/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.job.api.AcquiredExternalWorkerJob;
import org.flowable.job.api.ExternalWorkerJobAcquireBuilder;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.cmd.AcquireExternalWorkerJobsCmd;

public class ExternalWorkerJobAcquireBuilderImpl
implements ExternalWorkerJobAcquireBuilder {
    protected final CommandExecutor commandExecutor;
    protected final JobServiceConfiguration jobServiceConfiguration;
    protected String topic;
    protected Duration lockDuration;
    protected String scopeType;
    protected String tenantId;
    protected String authorizedUser;
    protected Collection<String> authorizedGroups;

    public ExternalWorkerJobAcquireBuilderImpl(CommandExecutor commandExecutor, JobServiceConfiguration jobServiceConfiguration) {
        this.commandExecutor = commandExecutor;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public ExternalWorkerJobAcquireBuilder topic(String topic, Duration lockDuration) {
        if (topic == null) {
            throw new FlowableIllegalArgumentException("topic is null");
        }
        if (lockDuration == null) {
            throw new FlowableIllegalArgumentException("lockDuration is null");
        }
        this.topic = topic;
        this.lockDuration = lockDuration;
        return this;
    }

    public ExternalWorkerJobAcquireBuilder onlyBpmn() {
        if ("cmmn".equals(this.scopeType)) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyCmmn() with onlyBpmn() in the same query");
        }
        if (this.scopeType != null) {
            throw new FlowableIllegalArgumentException("Cannot combine scopeType(String) with onlyBpmn() in the same query");
        }
        return this.scopeType("bpmn");
    }

    public ExternalWorkerJobAcquireBuilder onlyCmmn() {
        if ("bpmn".equals(this.scopeType)) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyBpmn() with onlyCmmn() in the same query");
        }
        if (this.scopeType != null) {
            throw new FlowableIllegalArgumentException("Cannot combine scopeType(String) with onlyCmmn() in the same query");
        }
        return this.scopeType("cmmn");
    }

    public ExternalWorkerJobAcquireBuilder scopeType(String scopeType) {
        this.scopeType = scopeType;
        return this;
    }

    public ExternalWorkerJobAcquireBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public ExternalWorkerJobAcquireBuilder forUserOrGroups(String userId, Collection<String> groups) {
        if (userId == null && (groups == null || groups.isEmpty())) {
            throw new FlowableIllegalArgumentException("at least one of userId or groups must be provided");
        }
        this.authorizedUser = userId;
        this.authorizedGroups = groups;
        return this;
    }

    public List<AcquiredExternalWorkerJob> acquireAndLock(int numberOfTasks, String workerId, int numberOfRetries) {
        while (numberOfRetries > 0) {
            try {
                return (List)this.commandExecutor.execute((Command)new AcquireExternalWorkerJobsCmd(workerId, numberOfTasks, this, this.jobServiceConfiguration));
            }
            catch (FlowableOptimisticLockingException ignored) {
                --numberOfRetries;
            }
        }
        return Collections.emptyList();
    }

    public String getTopic() {
        return this.topic;
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getAuthorizedUser() {
        return this.authorizedUser;
    }

    public Collection<String> getAuthorizedGroups() {
        return this.authorizedGroups;
    }
}

