/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.x509.authentication.X509CertificateExtractor;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderX509CertificateExtractor
implements X509CertificateExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHeaderX509CertificateExtractor.class);
    public static final String X509_HEADER = "-----BEGIN CERTIFICATE-----";
    public static final String X509_FOOTER = "-----END CERTIFICATE-----";
    private final String sslClientCertHeader;

    @Override
    public X509Certificate[] extract(HttpServletRequest request) {
        X509Certificate[] x509CertificateArray;
        String certHeaderValue = this.getCertFromHeader(request);
        if (StringUtils.isBlank((CharSequence)certHeaderValue)) {
            LOGGER.debug("No header [{}] found in request (or value was null)", (Object)this.sslClientCertHeader);
            return null;
        }
        if (Objects.requireNonNull(certHeaderValue).length() - X509_FOOTER.length() < X509_HEADER.length()) {
            LOGGER.debug("Header [{}] found but it is too short to parse. Header value: [{}]", (Object)this.sslClientCertHeader, (Object)certHeaderValue);
            return null;
        }
        LOGGER.trace("Located value [{}] from header [{}]. Parsing...", (Object)certHeaderValue, (Object)this.sslClientCertHeader);
        String body = RequestHeaderX509CertificateExtractor.sanitizeCertificateBody(certHeaderValue);
        LOGGER.debug("Certificate body to parse is [{}]", (Object)body);
        ByteArrayInputStream input = new ByteArrayInputStream(body.getBytes(StandardCharsets.ISO_8859_1));
        try {
            X509Certificate cert = CertUtils.readCertificate((InputStream)input);
            LOGGER.debug("Certificate extracted from header [{}] with subject: [{}]", (Object)this.sslClientCertHeader, (Object)cert.getSubjectDN());
            x509CertificateArray = new X509Certificate[]{cert};
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse certificate from header: [{}] with sanitized value: [{}]", (Object)this.sslClientCertHeader, (Object)body);
                LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
                return null;
            }
        }
        input.close();
        return x509CertificateArray;
    }

    private String getCertFromHeader(HttpServletRequest request) {
        String certHeaderValue = request.getHeader(this.sslClientCertHeader);
        if (StringUtils.isBlank((CharSequence)certHeaderValue)) {
            return null;
        }
        if ("(null)".equalsIgnoreCase(certHeaderValue)) {
            return null;
        }
        return StringUtils.trim((String)certHeaderValue);
    }

    private static String sanitizeCertificateBody(String certHeaderValue) {
        String body = certHeaderValue.substring(X509_HEADER.length(), certHeaderValue.length() - X509_FOOTER.length());
        body = body.replace(' ', '\n');
        body = body.replace('\t', '\n');
        return X509_HEADER.concat("\n").concat(body).concat("\n").concat(X509_FOOTER).concat("\n");
    }

    @Generated
    public String getSslClientCertHeader() {
        return this.sslClientCertHeader;
    }

    @Generated
    public RequestHeaderX509CertificateExtractor(String sslClientCertHeader) {
        this.sslClientCertHeader = sslClientCertHeader;
    }
}

