/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstrapcheckbox;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstrapcheckbox.BootstrapCheckBoxPickerConfig;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;
import org.apache.wicket.util.lang.Args;

public class BootstrapCheckBoxPicker
extends CheckBox {
    private final BootstrapCheckBoxPickerConfig config;

    public BootstrapCheckBoxPicker(String id) {
        this(id, null, new BootstrapCheckBoxPickerConfig());
    }

    public BootstrapCheckBoxPicker(String id, IModel<Boolean> model) {
        this(id, model, new BootstrapCheckBoxPickerConfig());
    }

    public BootstrapCheckBoxPicker(String id, IModel<Boolean> model, BootstrapCheckBoxPickerConfig config) {
        super(id, model);
        this.config = (BootstrapCheckBoxPickerConfig)((Object)Args.notNull((Object)((Object)config), (String)"config"));
    }

    public BootstrapCheckBoxPicker(String id, BootstrapCheckBoxPickerConfig config) {
        this(id, null, config);
    }

    protected void onComponentTag(ComponentTag tag) {
        IModel<String> warningMessage;
        IModel<String> onTitle;
        IModel<String> offTitle;
        IModel<String> onLabel;
        super.onComponentTag(tag);
        IModel<String> offLabel = this.getOffLabel();
        if (offLabel != null) {
            tag.put("data-off-label", (CharSequence)offLabel.getObject());
        }
        if ((onLabel = this.getOnLabel()) != null) {
            tag.put("data-on-label", (CharSequence)onLabel.getObject());
        }
        if ((offTitle = this.getOffTitle()) != null) {
            tag.put("data-off-title", (CharSequence)offTitle.getObject());
        }
        if ((onTitle = this.getOnTitle()) != null) {
            tag.put("data-on-title", (CharSequence)onTitle.getObject());
        }
        if ((warningMessage = this.getWarningMessage()) != null) {
            tag.put("data-warning-message", (CharSequence)warningMessage.getObject());
        }
    }

    public BootstrapCheckBoxPickerConfig getConfig() {
        return this.config;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JQueryPluginResourceReference(BootstrapCheckBoxPicker.class, "js/bootstrap-checkbox.js")));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.$((Component)this).chain((CharSequence)"checkboxpicker", (Config)this.getConfig(), new Config[0]).get()));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$(%s).hide();", this.getMarkupId())));
    }

    protected IModel<String> getOffLabel() {
        return Model.of((Serializable)((Object)"No"));
    }

    protected IModel<String> getOnLabel() {
        return Model.of((Serializable)((Object)"Yes"));
    }

    protected IModel<String> getOffTitle() {
        return null;
    }

    protected IModel<String> getOnTitle() {
        return null;
    }

    protected IModel<String> getWarningMessage() {
        return Model.of((Serializable)((Object)"Please do not use bootstrap-checkbox element in label element."));
    }
}

