/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalProvisioner;
import org.apereo.cas.configuration.model.support.scim.ScimProvisioningProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PrincipalProvisionerAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PrincipalProvisionerAction.class);
    private final ExecutorService executorService = Executors.newVirtualThreadPerTaskExecutor();
    private final PrincipalProvisioner principalProvisioner;
    private final ScimProvisioningProperties properties;

    protected Event doExecuteInternal(RequestContext requestContext) {
        Credential credential = WebUtils.getCredential((RequestContext)requestContext);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        if (credential == null || authentication == null) {
            LOGGER.warn("No credential or authentication found in the request context to provision");
            return this.success();
        }
        if (this.properties.isAsynchronous()) {
            this.executorService.execute(() -> this.provision(requestContext));
            return this.success();
        }
        boolean res = this.provision(requestContext);
        return res ? this.success() : this.error();
    }

    protected boolean provision(RequestContext requestContext) {
        Credential credential = WebUtils.getCredential((RequestContext)requestContext);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = authentication.getPrincipal();
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        LOGGER.debug("Starting to provision principal [{}] with registered service [{}]", (Object)principal, (Object)registeredService);
        boolean res = this.principalProvisioner.provision(authentication, credential, registeredService);
        String msg = String.format("Provisioning of principal %s is%s done successfully", principal, BooleanUtils.toString((boolean)res, (String)"", (String)" not"));
        LOGGER.debug(msg);
        return res;
    }

    @Generated
    public PrincipalProvisionerAction(PrincipalProvisioner principalProvisioner, ScimProvisioningProperties properties) {
        this.principalProvisioner = principalProvisioner;
        this.properties = properties;
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Generated
    public PrincipalProvisioner getPrincipalProvisioner() {
        return this.principalProvisioner;
    }

    @Generated
    public ScimProvisioningProperties getProperties() {
        return this.properties;
    }
}

