/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.google.common.collect;

import com.signalfx.shaded.checkerframework.checker.nullness.qual.Nullable;
import com.signalfx.shaded.google.common.annotations.GwtCompatible;
import com.signalfx.shaded.google.common.annotations.GwtIncompatible;
import com.signalfx.shaded.google.common.annotations.J2ktIncompatible;
import com.signalfx.shaded.google.common.collect.ElementTypesAreNonnullByDefault;
import com.signalfx.shaded.google.common.collect.ImmutableAsList;
import com.signalfx.shaded.google.common.collect.ImmutableCollection;
import com.signalfx.shaded.google.common.collect.ImmutableList;
import com.signalfx.shaded.google.common.collect.UnmodifiableListIterator;
import com.signalfx.shaded.javax.annotation.CheckForNull;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super E> action) {
        this.delegateList.forEach(action);
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    @CheckForNull
    Object[] internalArray() {
        return this.delegateList.internalArray();
    }

    @Override
    int internalArrayStart() {
        return this.delegateList.internalArrayStart();
    }

    @Override
    int internalArrayEnd() {
        return this.delegateList.internalArrayEnd();
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

