/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.naming.directory.SearchControls;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.attribute.AbstractQueryPersonAttributeDao;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchScope;
import org.ldaptive.handler.LdapEntryHandler;
import org.ldaptive.handler.SearchResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdaptivePersonAttributeDao
extends AbstractQueryPersonAttributeDao<FilterTemplate>
implements AutoCloseable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdaptivePersonAttributeDao.class);
    private String baseDN;
    private SearchControls searchControls;
    private ConnectionFactory connectionFactory;
    private String searchFilter;
    private String[] binaryAttributes;
    private LdapEntryHandler[] entryHandlers;
    private SearchResultHandler[] searchResultHandlers;

    protected List<PersonAttributes> getPeopleForQuery(FilterTemplate filter, String userName) {
        try {
            Objects.requireNonNull(this.searchFilter, "Search filter cannot be null");
            SearchOperation search = new SearchOperation(this.connectionFactory);
            search.setEntryHandlers(this.entryHandlers);
            search.setSearchResultHandlers(this.searchResultHandlers);
            SearchResponse response = search.execute(this.createRequest(filter));
            ArrayList<PersonAttributes> peopleAttributes = new ArrayList<PersonAttributes>(response.entrySize());
            for (LdapEntry entry : response.getEntries()) {
                String userNameAttribute;
                ArrayList<String> values;
                Map<String, List<Object>> attributes = this.convertLdapEntryToMap(entry);
                if (response.getDiagnosticMessage() != null && !response.getDiagnosticMessage().isEmpty()) {
                    values = new ArrayList<String>();
                    values.add(response.getDiagnosticMessage());
                    attributes.put("diagnosticMessage", values);
                }
                if (response.getMatchedDN() != null && !response.getMatchedDN().isEmpty()) {
                    values = new ArrayList();
                    values.add(response.getMatchedDN());
                    attributes.put("matchedDN", values);
                }
                SimplePersonAttributes person = attributes.containsKey(userNameAttribute = this.getConfiguredUserNameAttribute()) ? SimplePersonAttributes.fromAttribute((String)userNameAttribute, attributes) : new SimplePersonAttributes(userName, attributes);
                peopleAttributes.add((PersonAttributes)person);
            }
            return peopleAttributes;
        }
        catch (LdapException e) {
            throw new RuntimeException("Failed executing LDAP query " + String.valueOf(filter), e);
        }
    }

    protected FilterTemplate appendAttributeToQuery(FilterTemplate filter, String attribute, List<Object> values) {
        FilterTemplate query = Objects.requireNonNullElseGet(filter, () -> {
            Objects.requireNonNull(this.searchFilter, "Search filter cannot be null");
            return new FilterTemplate(this.searchFilter);
        });
        if (this.isUseAllQueryAttributes() && values.size() > 1 && (this.searchFilter.contains("{0}") || this.searchFilter.contains("{user}"))) {
            LOGGER.warn("Query value will be indeterminate due to multiple attributes and no username indicator. Use attribute [{}] in query instead", (Object)attribute);
        }
        if (!values.isEmpty() && this.searchFilter.contains("{" + attribute + "}")) {
            query.setParameter(attribute, (Object)values.getFirst().toString());
            LOGGER.debug("Updated LDAP search query parameter [{}]. Query: [{}]", (Object)attribute, (Object)query.format());
        }
        return query;
    }

    protected FilterTemplate finalizeQueryBuilder(FilterTemplate filterTemplate, Map<String, List<Object>> query) {
        if (filterTemplate.getParameters().isEmpty()) {
            String username = this.getUsernameAttributeProvider().getUsernameFromQuery(query);
            if (this.searchFilter.contains("{0}")) {
                LOGGER.debug("Filter template has not assigned any parameters. Using [{}] to populate the placeholder by index.", (Object)username);
                filterTemplate.setParameter(0, (Object)username);
            }
            if (this.searchFilter.contains("{user}")) {
                LOGGER.debug("Filter template has not assigned any parameters. Using [{}] to populate the placeholder variable.", (Object)username);
                filterTemplate.setParameter("user", (Object)username);
            }
        }
        return filterTemplate;
    }

    protected SearchRequest createRequest(FilterTemplate filter) {
        SearchRequest request = new SearchRequest();
        request.setBaseDn(this.baseDN);
        request.setFilter(filter);
        request.setBinaryAttributes(this.binaryAttributes);
        if (this.getResultAttributeMapping() != null && !this.getResultAttributeMapping().isEmpty()) {
            String[] attributes = this.getResultAttributeMapping().keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
            request.setReturnAttributes(attributes);
        } else if (this.searchControls.getReturningAttributes() != null && this.searchControls.getReturningAttributes().length > 0) {
            request.setReturnAttributes(this.searchControls.getReturningAttributes());
        } else {
            request.setReturnAttributes(ReturnAttributes.ALL_USER.value());
        }
        SearchScope searchScope = SearchScope.SUBTREE;
        for (SearchScope scope : SearchScope.values()) {
            if (scope.ordinal() != this.searchControls.getSearchScope()) continue;
            searchScope = scope;
        }
        request.setSearchScope(searchScope);
        request.setSizeLimit(Long.valueOf(this.searchControls.getCountLimit()).intValue());
        request.setTimeLimit(Duration.ofSeconds(this.searchControls.getTimeLimit()));
        return request;
    }

    protected Map<String, List<Object>> convertLdapEntryToMap(LdapEntry entry) {
        LinkedHashMap<String, List<Object>> attributeMap = new LinkedHashMap<String, List<Object>>(entry.size());
        for (LdapAttribute attr : entry.getAttributes()) {
            attributeMap.put(attr.getName(), new ArrayList(attr.getStringValues()));
        }
        LOGGER.debug("Converted LDAP DN entry [{}] to attribute map [{}]", (Object)entry.getDn(), attributeMap);
        return attributeMap;
    }

    @Override
    public void close() {
        if (this.connectionFactory != null) {
            this.connectionFactory.close();
        }
    }

    @Generated
    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    @Generated
    public void setSearchControls(SearchControls searchControls) {
        this.searchControls = searchControls;
    }

    @Generated
    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Generated
    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    @Generated
    public void setBinaryAttributes(String[] binaryAttributes) {
        this.binaryAttributes = binaryAttributes;
    }

    @Generated
    public void setEntryHandlers(LdapEntryHandler[] entryHandlers) {
        this.entryHandlers = entryHandlers;
    }

    @Generated
    public void setSearchResultHandlers(SearchResultHandler[] searchResultHandlers) {
        this.searchResultHandlers = searchResultHandlers;
    }

    @Generated
    public String getBaseDN() {
        return this.baseDN;
    }

    @Generated
    public SearchControls getSearchControls() {
        return this.searchControls;
    }

    @Generated
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Generated
    public String getSearchFilter() {
        return this.searchFilter;
    }

    @Generated
    public String[] getBinaryAttributes() {
        return this.binaryAttributes;
    }

    @Generated
    public LdapEntryHandler[] getEntryHandlers() {
        return this.entryHandlers;
    }

    @Generated
    public SearchResultHandler[] getSearchResultHandlers() {
        return this.searchResultHandlers;
    }
}

