/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.batch;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.rest.api.batch.BatchItem;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;

public final class BatchPayloadGenerator {
    private static final String HTTP_1_1 = "HTTP/1.1";

    public static <T extends BatchItem> String generate(List<T> items, String boundary) {
        StringBuilder payload = new StringBuilder();
        items.forEach(item -> {
            BatchItem bri;
            payload.append(boundary).append("\r\n");
            payload.append("Content-Type").append(": ").append("application/http").append('\n');
            payload.append("Content-Transfer-Encoding: binary").append('\n');
            payload.append("\r\n");
            if (item instanceof BatchRequestItem) {
                bri = (BatchRequestItem)BatchRequestItem.class.cast(item);
                payload.append(((BatchRequestItem)bri).getMethod()).append(' ').append(((BatchRequestItem)bri).getRequestURI());
                if (((BatchRequestItem)bri).getQueryString() != null) {
                    payload.append('?').append(((BatchRequestItem)bri).getQueryString());
                }
                payload.append(' ').append(HTTP_1_1).append('\n');
            }
            if (item instanceof BatchResponseItem) {
                bri = (BatchResponseItem)BatchResponseItem.class.cast(item);
                payload.append(HTTP_1_1).append(' ').append(((BatchResponseItem)bri).getStatus()).append(' ').append(Response.Status.fromStatusCode((int)((BatchResponseItem)bri).getStatus()).getReasonPhrase()).append('\n');
            }
            if (item.getHeaders() != null && !item.getHeaders().isEmpty()) {
                item.getHeaders().forEach((key, values) -> values.forEach(value -> payload.append((String)key).append(": ").append(value).append('\n')));
                payload.append("\r\n");
            }
            if (item.getContent() != null) {
                payload.append(item.getContent()).append('\n');
            }
        });
        payload.append(boundary).append("--").append('\n');
        return payload.toString();
    }

    private BatchPayloadGenerator() {
    }
}

