/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.encoding;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.wicket.util.lang.Args;

public class UrlEncoder {
    private final Type type;
    public static final UrlEncoder QUERY_INSTANCE = new UrlEncoder(Type.QUERY);
    public static final UrlEncoder PATH_INSTANCE = new UrlEncoder(Type.PATH);
    public static final UrlEncoder HEADER_INSTANCE = new UrlEncoder(Type.HEADER);

    protected UrlEncoder(Type type) {
        this.type = type;
    }

    public String encode(String s, String charsetName) {
        Args.notNull(charsetName, "charsetName");
        try {
            return this.encode(s, Charset.forName(charsetName));
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new RuntimeException(new UnsupportedEncodingException(charsetName));
        }
    }

    public String encode(String unsafeInput, Charset charset) {
        if (unsafeInput == null || unsafeInput.isEmpty()) {
            return unsafeInput;
        }
        Args.notNull(charset, "charset");
        byte[] bytes = unsafeInput.getBytes(charset);
        boolean original = true;
        for (byte b : bytes) {
            if (this.type.isAllowed(b) && b != 32 && b != 0) continue;
            original = false;
            break;
        }
        if (original) {
            return unsafeInput;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        for (byte b : bytes) {
            if (this.type.isAllowed(b)) {
                if (b == 32) {
                    bos.write(43);
                    continue;
                }
                bos.write(b);
                continue;
            }
            if (b == 0) {
                bos.writeBytes("NULL".getBytes(charset));
                continue;
            }
            bos.write(37);
            bos.write(Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16)));
            bos.write(Character.toUpperCase(Character.forDigit(b & 0xF, 16)));
        }
        return bos.toString(charset);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Type {
        QUERY{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 32 == c || 42 == c || 47 == c || 44 == c || 58 == c || 64 == c;
            }
        }
        ,
        PATH{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 42 == c || 38 == c || 43 == c || 44 == c || 59 == c || 61 == c || 58 == c || 64 == c;
            }
        }
        ,
        HEADER{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 35 == c || 38 == c || 43 == c || 94 == c || 96 == c || 124 == c;
            }
        };


        public abstract boolean isAllowed(int var1);

        protected boolean isAlpha(int c) {
            return c >= 97 && c <= 122 || c >= 65 && c <= 90;
        }

        protected boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        protected boolean isSubDelimiter(int c) {
            return 33 == c || 36 == c;
        }

        protected boolean isUnreserved(int c) {
            return this.isAlpha(c) || this.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
        }

        protected boolean isPchar(int c) {
            return this.isUnreserved(c) || this.isSubDelimiter(c);
        }
    }
}

