/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.OneTimeToken;
import org.apereo.cas.authentication.credential.OneTimeTokenCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialValidator;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GoogleAuthenticatorValidateTokenAction
extends AbstractMultifactorAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorValidateTokenAction.class);
    protected final CasConfigurationProperties casProperties;
    protected final OneTimeTokenCredentialRepository repository;
    protected final OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        GoogleAuthenticatorTokenCredential tokenCredential;
        String token = (String)requestContext.getRequestParameters().getRequired("token", String.class);
        Long accountId = (Long)requestContext.getRequestParameters().getRequired("accountId", Long.class);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        GoogleAuthenticatorToken validatedToken = (GoogleAuthenticatorToken)this.validator.validate(authentication, (OneTimeTokenCredential)(tokenCredential = new GoogleAuthenticatorTokenCredential(token, accountId)));
        if (validatedToken != null) {
            String principal = authentication.getPrincipal().getId();
            LOGGER.debug("Validated OTP token [{}] successfully for [{}]", (Object)validatedToken, (Object)principal);
            Boolean validate = requestContext.getRequestParameters().getBoolean("validate");
            if (validate == null || !validate.booleanValue()) {
                this.validator.store((OneTimeToken)validatedToken);
            }
            return this.success();
        }
        LOGGER.warn("Authorization of OTP token [{}] has failed", (Object)token);
        throw new FailedLoginException("Failed to authenticate code " + token);
    }

    @Generated
    public GoogleAuthenticatorValidateTokenAction(CasConfigurationProperties casProperties, OneTimeTokenCredentialRepository repository, OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator) {
        this.casProperties = casProperties;
        this.repository = repository;
        this.validator = validator;
    }
}

