/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.cipher;

import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.token.cipher.JwtTicketCipherExecutor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceJwtTicketCipherExecutor
extends JwtTicketCipherExecutor
implements RegisteredServiceCipherExecutor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceJwtTicketCipherExecutor.class);

    public String decode(String data, Optional<RegisteredService> service) {
        RegisteredService registeredService;
        if (service.isPresent() && this.supports(registeredService = service.get())) {
            LOGGER.debug("Found signing and/or encryption keys for [{}] in service registry to decode", (Object)registeredService.getServiceId());
            JwtTicketCipherExecutor cipher = this.getTokenTicketCipherExecutorForService(registeredService);
            if (cipher.isEnabled()) {
                return cipher.decode((Serializable)((Object)data), new Object[]{registeredService});
            }
        }
        return this.decode((Serializable)((Object)data), ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY);
    }

    public String encode(String data, Optional<RegisteredService> service) {
        RegisteredService registeredService;
        if (service.isPresent() && this.supports(registeredService = service.get())) {
            LOGGER.debug("Found signing and/or encryption keys for [{}] in service registry to encode", (Object)registeredService.getServiceId());
            JwtTicketCipherExecutor cipher = this.getTokenTicketCipherExecutorForService(registeredService);
            if (cipher.isEnabled()) {
                return (String)cipher.encode(data);
            }
        }
        return this.encode((Serializable)((Object)data), ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY);
    }

    public boolean supports(RegisteredService registeredService) {
        return this.getSigningKey(registeredService).isPresent() || this.getEncryptionKey(registeredService).isPresent();
    }

    public JwtTicketCipherExecutor getTokenTicketCipherExecutorForService(RegisteredService registeredService) {
        String encryptionKey = this.getEncryptionKey(registeredService).orElse("");
        String signingKey = this.getSigningKey(registeredService).orElse("");
        JwtTicketCipherExecutor cipher = this.createCipherExecutorInstance(encryptionKey, signingKey, registeredService);
        BaseStringCipherExecutor.CipherOperationsStrategyType order = this.getCipherOperationsStrategyType(registeredService).orElse(BaseStringCipherExecutor.CipherOperationsStrategyType.ENCRYPT_AND_SIGN);
        cipher.setStrategyType(order);
        cipher.setSigningEnabled(this.isSigningEnabledForRegisteredService(registeredService));
        cipher.setEncryptionEnabled(this.isEncryptionEnabledForRegisteredService(registeredService));
        return cipher;
    }

    protected JwtTicketCipherExecutor createCipherExecutorInstance(String encryptionKey, String signingKey, RegisteredService registeredService) {
        JwtTicketCipherExecutor cipher = new JwtTicketCipherExecutor(encryptionKey, signingKey, StringUtils.isNotBlank((CharSequence)encryptionKey), StringUtils.isNotBlank((CharSequence)signingKey), 0, 0);
        String encryptionAlg = this.getEncryptionAlgRegisteredServiceProperty().isAssignedTo(registeredService) ? this.getEncryptionAlgRegisteredServiceProperty().getPropertyValue(registeredService).value() : "A256CBC-HS512";
        cipher.setContentEncryptionAlgorithmIdentifier(encryptionAlg);
        cipher.getCommonHeaders().putAll(CollectionUtils.wrap((String)CUSTOM_HEADER_REGISTERED_SERVICE_ID, (Object)registeredService.getId()));
        return cipher;
    }

    public Optional<String> getSigningKey(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties property = this.getSigningKeyRegisteredServiceProperty();
        if (property.isAssignedTo(registeredService)) {
            String signingKey = property.getPropertyValue(registeredService).value();
            return Optional.of(signingKey);
        }
        return Optional.empty();
    }

    public Optional<String> getEncryptionKey(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties property = this.getEncryptionKeyRegisteredServiceProperty();
        if (property.isAssignedTo(registeredService)) {
            String key = property.getPropertyValue(registeredService).value();
            return Optional.of(key);
        }
        return Optional.empty();
    }

    protected boolean isSigningEnabledForRegisteredService(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties prop = this.getCipherOperationRegisteredServiceSigningEnabledProperty();
        if (prop.isAssignedTo(registeredService)) {
            return prop.getPropertyBooleanValue(registeredService);
        }
        return BooleanUtils.toBoolean((String)prop.getDefaultValue());
    }

    protected boolean isEncryptionEnabledForRegisteredService(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties prop = this.getCipherOperationRegisteredServiceEncryptionEnabledProperty();
        if (prop.isAssignedTo(registeredService)) {
            return prop.getPropertyBooleanValue(registeredService);
        }
        return BooleanUtils.toBoolean((String)prop.getDefaultValue());
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getSigningKeyRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET_SIGNING_KEY;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getEncryptionKeyRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET_ENCRYPTION_KEY;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getEncryptionAlgRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET_ENCRYPTION_ALG;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherOperationRegisteredServiceSigningEnabledProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET_SIGNING_ENABLED;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherOperationRegisteredServiceEncryptionEnabledProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET_ENCRYPTION_ENABLED;
    }

    @Generated
    public RegisteredServiceJwtTicketCipherExecutor() {
    }
}

