/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.clients.producer.UniformStickyPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UniformStickyPartitionerTest {
    private static final Node[] NODES = new Node[]{new Node(0, "localhost", 99), new Node(1, "localhost", 100), new Node(2, "localhost", 101)};
    private static final String TOPIC_A = "TOPIC_A";
    private static final String TOPIC_B = "TOPIC_B";

    @Test
    public void testRoundRobinWithUnavailablePartitions() {
        int i;
        List<PartitionInfo> partitions = Arrays.asList(new PartitionInfo("test", 1, null, NODES, NODES), new PartitionInfo("test", 2, NODES[1], NODES, NODES), new PartitionInfo("test", 0, NODES[0], NODES, NODES));
        int countForPart0 = 0;
        int countForPart2 = 0;
        int part = 0;
        UniformStickyPartitioner partitioner = new UniformStickyPartitioner();
        Cluster cluster = new Cluster("clusterId", Arrays.asList(NODES[0], NODES[1], NODES[2]), partitions, Collections.emptySet(), Collections.emptySet());
        for (i = 0; i < 50; ++i) {
            part = partitioner.partition("test", null, null, null, null, cluster);
            Assertions.assertTrue((part == 0 || part == 2 ? 1 : 0) != 0, (String)"We should never choose a leader-less node in round robin");
            if (part == 0) {
                ++countForPart0;
                continue;
            }
            ++countForPart2;
        }
        partitioner.onNewBatch("test", cluster, part);
        for (i = 1; i <= 50; ++i) {
            part = partitioner.partition("test", null, null, null, null, cluster);
            Assertions.assertTrue((part == 0 || part == 2 ? 1 : 0) != 0, (String)"We should never choose a leader-less node in round robin");
            if (part == 0) {
                ++countForPart0;
                continue;
            }
            ++countForPart2;
        }
        Assertions.assertEquals((int)countForPart0, (int)countForPart2, (String)"The distribution between two available partitions should be even");
    }

    @Test
    public void testRoundRobinWithKeyBytes() {
        List<PartitionInfo> allPartitions = Arrays.asList(new PartitionInfo(TOPIC_A, 0, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_A, 1, NODES[1], NODES, NODES), new PartitionInfo(TOPIC_A, 2, NODES[1], NODES, NODES), new PartitionInfo(TOPIC_B, 0, NODES[0], NODES, NODES));
        Cluster testCluster = new Cluster("clusterId", Arrays.asList(NODES[0], NODES[1], NODES[2]), allPartitions, Collections.emptySet(), Collections.emptySet());
        HashMap<Integer, Integer> partitionCount = new HashMap<Integer, Integer>();
        byte[] keyBytes = "key".getBytes();
        int partition = 0;
        UniformStickyPartitioner partitioner = new UniformStickyPartitioner();
        for (int i = 0; i < 30; ++i) {
            partition = partitioner.partition(TOPIC_A, null, keyBytes, null, null, testCluster);
            Integer count = (Integer)partitionCount.get(partition);
            if (null == count) {
                count = 0;
            }
            partitionCount.put(partition, count + 1);
            if (i % 5 != 0) continue;
            partitioner.partition(TOPIC_B, null, keyBytes, null, null, testCluster);
        }
        partitioner.onNewBatch(TOPIC_A, testCluster, partition);
        partitioner.onNewBatch(TOPIC_B, testCluster, 0);
        int oldPart = partition;
        for (int i = 0; i < 30; ++i) {
            partition = partitioner.partition(TOPIC_A, null, keyBytes, null, null, testCluster);
            Integer count = (Integer)partitionCount.get(partition);
            if (null == count) {
                count = 0;
            }
            partitionCount.put(partition, count + 1);
            if (i % 5 != 0) continue;
            partitioner.partition(TOPIC_B, null, keyBytes, null, null, testCluster);
        }
        int newPart = partition;
        partitioner.onNewBatch(TOPIC_A, testCluster, oldPart);
        for (int i = 0; i < 30; ++i) {
            partition = partitioner.partition(TOPIC_A, null, keyBytes, null, null, testCluster);
            Integer count = (Integer)partitionCount.get(partition);
            if (null == count) {
                count = 0;
            }
            partitionCount.put(partition, count + 1);
            if (i % 5 != 0) continue;
            partitioner.partition(TOPIC_B, null, keyBytes, null, null, testCluster);
        }
        Assertions.assertEquals((int)30, (int)((Integer)partitionCount.get(oldPart)));
        Assertions.assertEquals((int)60, (int)((Integer)partitionCount.get(newPart)));
    }

    @Test
    public void testRoundRobinWithNullKeyBytes() {
        List<PartitionInfo> allPartitions = Arrays.asList(new PartitionInfo(TOPIC_A, 0, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_A, 1, NODES[1], NODES, NODES), new PartitionInfo(TOPIC_A, 2, NODES[1], NODES, NODES), new PartitionInfo(TOPIC_B, 0, NODES[0], NODES, NODES));
        Cluster testCluster = new Cluster("clusterId", Arrays.asList(NODES[0], NODES[1], NODES[2]), allPartitions, Collections.emptySet(), Collections.emptySet());
        HashMap<Integer, Integer> partitionCount = new HashMap<Integer, Integer>();
        int partition = 0;
        UniformStickyPartitioner partitioner = new UniformStickyPartitioner();
        for (int i = 0; i < 30; ++i) {
            partition = partitioner.partition(TOPIC_A, null, null, null, null, testCluster);
            Integer count = (Integer)partitionCount.get(partition);
            if (null == count) {
                count = 0;
            }
            partitionCount.put(partition, count + 1);
            if (i % 5 != 0) continue;
            partitioner.partition(TOPIC_B, null, null, null, null, testCluster);
        }
        partitioner.onNewBatch(TOPIC_A, testCluster, partition);
        partitioner.onNewBatch(TOPIC_B, testCluster, 0);
        int oldPart = partition;
        for (int i = 0; i < 30; ++i) {
            partition = partitioner.partition(TOPIC_A, null, null, null, null, testCluster);
            Integer count = (Integer)partitionCount.get(partition);
            if (null == count) {
                count = 0;
            }
            partitionCount.put(partition, count + 1);
            if (i % 5 != 0) continue;
            partitioner.partition(TOPIC_B, null, null, null, null, testCluster);
        }
        int newPart = partition;
        partitioner.onNewBatch(TOPIC_A, testCluster, oldPart);
        for (int i = 0; i < 30; ++i) {
            partition = partitioner.partition(TOPIC_A, null, null, null, null, testCluster);
            Integer count = (Integer)partitionCount.get(partition);
            if (null == count) {
                count = 0;
            }
            partitionCount.put(partition, count + 1);
            if (i % 5 != 0) continue;
            partitioner.partition(TOPIC_B, null, null, null, null, testCluster);
        }
        Assertions.assertEquals((int)30, (int)((Integer)partitionCount.get(oldPart)));
        Assertions.assertEquals((int)60, (int)((Integer)partitionCount.get(newPart)));
    }
}

