/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.record.MultiRecordsSend;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiRecordsSendTest {
    @Test
    public void testSendsFreedAfterWriting() throws IOException {
        int numChunks = 4;
        int chunkSize = 32;
        int totalSize = numChunks * chunkSize;
        LinkedList<ByteBufferSend> sends = new LinkedList<ByteBufferSend>();
        ByteBuffer[] chunks = new ByteBuffer[numChunks];
        for (int i = 0; i < numChunks; ++i) {
            ByteBuffer buffer;
            chunks[i] = buffer = ByteBuffer.wrap(TestUtils.randomBytes(chunkSize));
            sends.add(new ByteBufferSend(new ByteBuffer[]{buffer}));
        }
        MultiRecordsSend send = new MultiRecordsSend(sends);
        Assertions.assertEquals((long)totalSize, (long)send.size());
        for (int i = 0; i < numChunks; ++i) {
            Assertions.assertEquals((int)(numChunks - i), (int)send.numResidentSends());
            NonOverflowingByteBufferChannel out = new NonOverflowingByteBufferChannel(chunkSize);
            send.writeTo((TransferableChannel)out);
            out.close();
            Assertions.assertEquals((Object)chunks[i], (Object)out.buffer());
        }
        Assertions.assertEquals((int)0, (int)send.numResidentSends());
        Assertions.assertTrue((boolean)send.completed());
    }

    private static class NonOverflowingByteBufferChannel
    extends ByteBufferChannel {
        private NonOverflowingByteBufferChannel(long size) {
            super(size);
        }

        @Override
        public long write(ByteBuffer[] srcs) {
            if (!this.buffer().hasRemaining()) {
                return 0L;
            }
            return super.write(srcs);
        }
    }
}

