/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.session;

import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import org.apereo.cas.client.session.SessionMappingStorage;
import org.apereo.cas.client.session.SingleSignOutFilter;

public final class SingleSignOutHttpSessionListener
implements HttpSessionListener {
    private SessionMappingStorage sessionMappingStorage;

    private static SessionMappingStorage getSessionMappingStorage() {
        return SingleSignOutFilter.getSingleSignOutHandler().getSessionMappingStorage();
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.sessionMappingStorage == null) {
            this.sessionMappingStorage = SingleSignOutHttpSessionListener.getSessionMappingStorage();
        }
        HttpSession session = event.getSession();
        this.sessionMappingStorage.removeBySessionById(session.getId());
    }
}

