/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class SamlRegisteredServiceMetadataHealthIndicator
extends AbstractHealthIndicator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceMetadataHealthIndicator.class);
    private final SamlRegisteredServiceMetadataResolutionPlan metadataResolutionPlan;
    private final ServicesManager servicesManager;

    protected void doHealthCheck(Health.Builder builder) {
        Collection samlServices = this.servicesManager.findServiceBy(SamlRegisteredService.class::isInstance);
        Collection<SamlRegisteredServiceMetadataResolver> availableResolvers = this.metadataResolutionPlan.getRegisteredMetadataResolvers();
        LOGGER.trace("There are [{}] metadata resolver(s) available in the chain", (Object)availableResolvers.size());
        builder.up();
        builder.withDetail("name", (Object)((Object)((Object)this)).getClass().getSimpleName());
        AtomicInteger count = new AtomicInteger();
        samlServices.stream().map(SamlRegisteredService.class::cast).forEach(service -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", service.getName());
            map.put("id", service.getId());
            map.put("metadataLocation", service.getMetadataLocation());
            map.put("serviceId", service.getServiceId());
            boolean availability = availableResolvers.stream().filter(Objects::nonNull).filter(r -> r.supports((SamlRegisteredService)service)).anyMatch(r -> r.isAvailable((SamlRegisteredService)service));
            map.put("availability", BooleanUtils.toStringYesNo((boolean)availability));
            builder.withDetail(service.getName(), map);
            if (!availability) {
                LOGGER.debug("No metadata resolver is available for service [{}]", (Object)service.getName());
                count.getAndIncrement();
            }
        });
        if (!samlServices.isEmpty() && count.intValue() == samlServices.size()) {
            builder.down();
        }
    }

    @Generated
    public SamlRegisteredServiceMetadataHealthIndicator(SamlRegisteredServiceMetadataResolutionPlan metadataResolutionPlan, ServicesManager servicesManager) {
        this.metadataResolutionPlan = metadataResolutionPlan;
        this.servicesManager = servicesManager;
    }
}

