/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import kafka.network.SocketServer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(types={Type.KRAFT})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0004\t\u0001=A\u0001B\u0006\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\u0006=\u0001!\ta\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006_\u0001!\t\u0001\n\u0005\u0006g\u0001!I\u0001\u000e\u0005\u0006\u001d\u0002!Ia\u0014\u0002\u001f\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d*fcV,7\u000f\u001e+fgRT!!\u0003\u0006\u0002\rM,'O^3s\u0015\tYA\"A\u0003lC\u001a\\\u0017MC\u0001\u000e\u0003\u0011)h.\u001b;\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\rdWo\u001d;feB\u0011\u0001\u0004H\u0007\u00023)\u0011!dG\u0001\u0005i\u0016\u001cHOC\u0001\f\u0013\ti\u0012DA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011\u0001E\t\t\u0003C\u0001i\u0011\u0001\u0003\u0005\u0006-\t\u0001\raF\u0001(i\u0016\u001cH/\u00117m_\u000e\fG/\u001a)s_\u0012,8-\u001a:t\u0013\u0012\u001cVM\u001c;U_\u000e{g\u000e\u001e:pY2,'\u000fF\u0001&!\t\tb%\u0003\u0002(%\t!QK\\5uQ\t\u0019\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00059Z#aC\"mkN$XM\u001d+fgR\f!\u0006^3ti\u0006cGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u00148/\u00133TK:$Hk\u001c(p]\u000e{g\u000e\u001e:pY2,'\u000f\u000b\u0003\u0005SE\u0012\u0014aC2p]R\u0014x\u000e\u001c7feNl\u0012aA\u0001\"g\u0016tG-\u00118e%\u0016\u001cW-\u001b<f\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d\u000b\u0004k\tK\u0005C\u0001\u001cA\u001b\u00059$B\u0001\u001d:\u0003!\u0011X-];fgR\u001c(B\u0001\u001e<\u0003\u0019\u0019w.\\7p]*\u00111\u0002\u0010\u0006\u0003{y\na!\u00199bG\",'\"A \u0002\u0007=\u0014x-\u0003\u0002Bo\tY\u0012\t\u001c7pG\u0006$X\r\u0015:pIV\u001cWM]%egJ+7\u000f]8og\u0016DQaQ\u0003A\u0002\u0011\u000bAb]8ve\u000e,'I]8lKJ\u0004\"!R$\u000e\u0003\u0019S!!C\u000e\n\u0005!3%\u0001\u0004\"s_.,'oU3sm\u0016\u0014\b\"\u0002&\u0006\u0001\u0004Y\u0015\u0001E2p]R\u0014x\u000e\u001c7feN+'O^3s!\t)E*\u0003\u0002N\r\n\u00012i\u001c8ue>dG.\u001a:TKJ4XM]\u0001\u0012G>tg.Z2u\u0003:$'+Z2fSZ,GcA\u001bQ1\")\u0011K\u0002a\u0001%\u000612m\u001c8ue>dG.\u001a:T_\u000e\\W\r^*feZ,'\u000f\u0005\u0002T-6\tAK\u0003\u0002V7\u00059a.\u001a;x_J\\\u0017BA,U\u00051\u0019vnY6fiN+'O^3s\u0011\u0015If\u00011\u0001[\u0003\u001d\u0011X-];fgR\u0004\"AN.\n\u0005q;$AG!mY>\u001c\u0017\r^3Qe>$WoY3s\u0013\u0012\u001c(+Z9vKN$\b\u0006\u0002\u0001_Q&\u0004\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\u0007\u0005\u0004\u0018N\u0003\u0002dI\u00069!.\u001e9ji\u0016\u0014(BA3?\u0003\u0015QWO\\5u\u0013\t9\u0007MA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003aDC\u0001A6icB\u0011An\\\u0007\u0002[*\u0011a\u000eY\u0001\nKb$XM\\:j_:L!\u0001]7\u0003\u0015\u0015CH/\u001a8e/&$\b\u000eL\u0001sG\u0005\u0019\bC\u0001;w\u001b\u0005)(BA3\u001a\u0013\t9XOA\u000bDYV\u001cH/\u001a:UKN$X\t\u001f;f]NLwN\\:)\t\u0001IH0 \t\u0003UiL!a_\u0016\u0003'\rcWo\u001d;feR+7\u000f\u001e#fM\u0006,H\u000e^:\u0002\u000bQL\b/Z:-\u0003y$\u0013a`\u0005\u0005\u0003\u0003\t\u0019!A\u0003L%\u00063EKC\u0002\u0002\u0006-\nA\u0001V=qK\"2\u0001!!\u0003i\u0003\u001f\u00012aXA\u0006\u0013\r\ti\u0001\u0019\u0002\u0004)\u0006<\u0017EAA\t\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8")
public class AllocateProducerIdsRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest
    public void testAllocateProducersIdSentToController() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        BrokerServer sourceBroker = (BrokerServer)raftCluster.brokers().values().stream().findFirst().get();
        int controllerId = sourceBroker.raftManager().leaderAndEpoch().leaderId().getAsInt();
        ControllerServer controllerServer = raftCluster.controllers().values().stream().filter(x$1 -> x$1.config().nodeId() == controllerId).findFirst().get();
        AllocateProducerIdsResponse allocateResponse = this.sendAndReceiveAllocateProducerIds(sourceBroker, controllerServer);
        Assertions.assertEquals((Object)Errors.NONE, (Object)allocateResponse.error());
        Assertions.assertEquals((int)1000, (int)allocateResponse.data().producerIdLen());
        Assertions.assertTrue((allocateResponse.data().producerIdStart() >= 0L ? 1 : 0) != 0);
    }

    @ClusterTest(controllers=3)
    public void testAllocateProducersIdSentToNonController() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        BrokerServer sourceBroker = (BrokerServer)raftCluster.brokers().values().stream().findFirst().get();
        int controllerId = sourceBroker.raftManager().leaderAndEpoch().leaderId().getAsInt();
        ControllerServer controllerServer = raftCluster.controllers().values().stream().filter(x$2 -> x$2.config().nodeId() != controllerId).findFirst().get();
        AllocateProducerIdsResponse allocateResponse = this.sendAndReceiveAllocateProducerIds(sourceBroker, controllerServer);
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)allocateResponse.data().errorCode()));
    }

    private AllocateProducerIdsResponse sendAndReceiveAllocateProducerIds(BrokerServer sourceBroker, ControllerServer controllerServer) {
        AllocateProducerIdsRequest allocateRequest = (AllocateProducerIdsRequest)new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData().setBrokerId(sourceBroker.config().brokerId()).setBrokerEpoch(sourceBroker.lifecycleManager().brokerEpoch())).build();
        return this.connectAndReceive(controllerServer.socketServer(), allocateRequest);
    }

    private AllocateProducerIdsResponse connectAndReceive(SocketServer controllerSocketServer, AllocateProducerIdsRequest request) {
        return (AllocateProducerIdsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controllerSocketServer, this.cluster.controllerListenerName().get(), ClassTag$.MODULE$.apply(AllocateProducerIdsResponse.class));
    }

    public AllocateProducerIdsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

