/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.executor;

import lombok.Generated;
import org.apereo.cas.configuration.model.core.web.flow.WebflowProperties;
import org.apereo.cas.configuration.model.core.web.flow.WebflowServerSessionsProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.flow.executor.CasFlowExecutor;
import org.apereo.cas.web.flow.executor.ClientFlowExecutionRepository;
import org.apereo.cas.web.flow.executor.EncryptedTranscoder;
import org.apereo.cas.web.flow.executor.Transcoder;
import org.apereo.cas.web.flow.executor.WebflowCipherBean;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.impl.SessionBindingConversationManager;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.StaticFlowExecutionListenerLoader;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.impl.DefaultFlowExecutionRepository;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SerializedFlowExecutionSnapshotFactory;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;

public class WebflowExecutorFactory {
    private final WebflowProperties webflowProperties;
    private final FlowDefinitionRegistry flowDefinitionRegistry;
    private final CipherExecutor webflowCipherExecutor;
    private final FlowExecutionListener[] executionListeners;
    private final FlowUrlHandler flowUrlHandler;

    public FlowExecutor build() {
        if (this.webflowProperties.getSession().isStorage()) {
            return this.buildFlowExecutorViaServerSessionBindingExecution();
        }
        return this.buildFlowExecutorViaClientFlowExecution();
    }

    private FlowExecutor buildFlowExecutorViaServerSessionBindingExecution() {
        SessionBindingConversationManager conversationManager = new SessionBindingConversationManager();
        WebflowServerSessionsProperties session = this.webflowProperties.getSession().getServer();
        conversationManager.setLockTimeoutSeconds((int)Beans.newDuration((String)session.getLockTimeout()).toSeconds());
        conversationManager.setMaxConversations(session.getMaxConversations());
        FlowExecutionImplFactory executionFactory = new FlowExecutionImplFactory();
        executionFactory.setExecutionListenerLoader((FlowExecutionListenerLoader)new StaticFlowExecutionListenerLoader(this.executionListeners));
        SerializedFlowExecutionSnapshotFactory flowExecutionSnapshotFactory = new SerializedFlowExecutionSnapshotFactory((FlowExecutionFactory)executionFactory, (FlowDefinitionLocator)this.flowDefinitionRegistry);
        flowExecutionSnapshotFactory.setCompress(session.isCompress());
        DefaultFlowExecutionRepository repository = new DefaultFlowExecutionRepository((ConversationManager)conversationManager, (FlowExecutionSnapshotFactory)flowExecutionSnapshotFactory);
        executionFactory.setExecutionKeyFactory((FlowExecutionKeyFactory)repository);
        return this.buildCasFlowExecutor((FlowExecutionFactory)executionFactory, (FlowExecutionRepository)repository);
    }

    private FlowExecutor buildFlowExecutorViaClientFlowExecution() {
        ClientFlowExecutionRepository repository = new ClientFlowExecutionRepository();
        repository.setWebflowProperties(this.webflowProperties);
        repository.setFlowDefinitionLocator((FlowDefinitionLocator)this.flowDefinitionRegistry);
        repository.setTranscoder(this.getWebflowStateTranscoder());
        FlowExecutionImplFactory executionFactory = new FlowExecutionImplFactory();
        executionFactory.setExecutionKeyFactory((FlowExecutionKeyFactory)repository);
        repository.setFlowExecutionFactory((FlowExecutionFactory)executionFactory);
        executionFactory.setExecutionListenerLoader((FlowExecutionListenerLoader)new StaticFlowExecutionListenerLoader(this.executionListeners));
        return this.buildCasFlowExecutor((FlowExecutionFactory)executionFactory, repository);
    }

    private CasFlowExecutorImpl buildCasFlowExecutor(FlowExecutionFactory executionFactory, FlowExecutionRepository repository) {
        return new CasFlowExecutorImpl(new FlowExecutorImpl((FlowDefinitionLocator)this.flowDefinitionRegistry, executionFactory, repository), repository, this.flowUrlHandler);
    }

    private Transcoder getWebflowStateTranscoder() {
        WebflowCipherBean cipherBean = new WebflowCipherBean(this.webflowCipherExecutor);
        return new EncryptedTranscoder(cipherBean);
    }

    @Generated
    public WebflowExecutorFactory(WebflowProperties webflowProperties, FlowDefinitionRegistry flowDefinitionRegistry, CipherExecutor webflowCipherExecutor, FlowExecutionListener[] executionListeners, FlowUrlHandler flowUrlHandler) {
        this.webflowProperties = webflowProperties;
        this.flowDefinitionRegistry = flowDefinitionRegistry;
        this.webflowCipherExecutor = webflowCipherExecutor;
        this.executionListeners = executionListeners;
        this.flowUrlHandler = flowUrlHandler;
    }

    static class CasFlowExecutorImpl
    implements CasFlowExecutor {
        private final FlowExecutorImpl flowExecutor;
        private final FlowExecutionRepository flowExecutionRepository;
        private final FlowUrlHandler flowUrlHandler;

        @Generated
        public CasFlowExecutorImpl(FlowExecutorImpl flowExecutor, FlowExecutionRepository flowExecutionRepository, FlowUrlHandler flowUrlHandler) {
            this.flowExecutor = flowExecutor;
            this.flowExecutionRepository = flowExecutionRepository;
            this.flowUrlHandler = flowUrlHandler;
        }

        @Generated
        public FlowExecutorImpl getFlowExecutor() {
            return this.flowExecutor;
        }

        @Override
        @Generated
        public FlowExecutionRepository getFlowExecutionRepository() {
            return this.flowExecutionRepository;
        }

        @Override
        @Generated
        public FlowUrlHandler getFlowUrlHandler() {
            return this.flowUrlHandler;
        }

        @Generated
        public FlowExecutionResult launchExecution(String arg0, MutableAttributeMap<?> arg1, ExternalContext arg2) throws FlowException {
            return this.getFlowExecutor().launchExecution(arg0, arg1, arg2);
        }

        @Generated
        public FlowExecutionResult resumeExecution(String arg0, ExternalContext arg1) throws FlowException {
            return this.getFlowExecutor().resumeExecution(arg0, arg1);
        }
    }
}

