/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowCredentialProvider;
import org.apereo.cas.web.flow.authentication.DefaultCasWebflowCredentialProvider;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractCasWebflowEventResolver
implements CasWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCasWebflowEventResolver.class);
    private final CasWebflowEventResolutionConfigurationContext configurationContext;

    @Override
    public Set<Event> resolve(RequestContext context) throws Throwable {
        LOGGER.trace("Attempting to resolve authentication event using resolver [{}]", (Object)this.getName());
        WebUtils.putWarnCookieIfRequestParameterPresent((CasCookieBuilder)this.configurationContext.getWarnCookieGenerator(), (RequestContext)context);
        WebUtils.putPublicWorkstationToFlowIfRequestParameterPresent((RequestContext)context);
        return this.resolveInternal(context);
    }

    @Override
    public Event resolveSingle(RequestContext context) throws Throwable {
        Set<Event> events = this.resolve(context);
        if (events == null || events.isEmpty()) {
            LOGGER.trace("No event could be determined");
            return null;
        }
        Event event = events.iterator().next();
        LOGGER.debug("Resolved single event [{}] via [{}] for this context", (Object)event.getId(), (Object)event.getSource().getClass().getName());
        String targetState = WebUtils.getTargetTransition((RequestContext)context);
        return (Event)FunctionUtils.doIf((StringUtils.isNotBlank((CharSequence)targetState) && event.getId().equals("success") ? 1 : 0) != 0, () -> new EventFactorySupport().event((Object)this, targetState), () -> event).get();
    }

    protected Event newEvent(String id, Throwable error) {
        return this.newEvent(id, (AttributeMap)new LocalAttributeMap("error", (Object)error));
    }

    protected Event newEvent(String id) {
        return this.newEvent(id, (AttributeMap)new LocalAttributeMap());
    }

    protected Event newEvent(String id, AttributeMap attributes) {
        return new Event((Object)this, id, attributes);
    }

    protected List<Credential> getCredentialFromContext(RequestContext context) {
        ApplicationContext applicationContext = context.getActiveFlow().getApplicationContext();
        CasWebflowCredentialProvider credentialProvider = ApplicationContextProvider.getBean((ApplicationContext)applicationContext, (String)"casWebflowCredentialProvider", CasWebflowCredentialProvider.class).orElseGet(DefaultCasWebflowCredentialProvider::new);
        return credentialProvider.extract(context);
    }

    protected Event grantTicketGrantingTicketToAuthenticationResult(RequestContext context, AuthenticationResultBuilder authenticationResultBuilder, Service service) {
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)authenticationResultBuilder, (RequestContext)context);
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
        return this.newEvent("success");
    }

    protected Service resolveServiceFromAuthenticationRequest(Service service) throws Throwable {
        return this.configurationContext.getAuthenticationRequestServiceSelectionStrategies().resolveService(service);
    }

    protected Service resolveServiceFromAuthenticationRequest(RequestContext context) throws Throwable {
        WebApplicationService ctxService = WebUtils.getService((RequestContext)context);
        return this.resolveServiceFromAuthenticationRequest((Service)ctxService);
    }

    protected Set<Event> handleAuthenticationTransactionAndGrantTicketGrantingTicket(RequestContext context) throws Throwable {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        try {
            List<Credential> credentials = this.getCredentialFromContext(context);
            AuthenticationResultBuilder builderResult = WebUtils.getAuthenticationResultBuilder((RequestContext)context);
            LOGGER.debug("Handling authentication transaction for credentials [{}]", credentials);
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            AuthenticationResultBuilder builder = this.configurationContext.getAuthenticationSystemSupport().handleAuthenticationTransaction((Service)service, builderResult, credentials.toArray(Credential.EMPTY_CREDENTIALS_ARRAY));
            LOGGER.debug("Issuing ticket-granting tickets for service [{}]", (Object)service);
            return CollectionUtils.wrapSet((Object)this.grantTicketGrantingTicketToAuthenticationResult(context, builder, (Service)service));
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            this.configurationContext.getCasWebflowExceptionCatalog().translateException(context, e);
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            return CollectionUtils.wrapSet((Object)this.getAuthenticationFailureErrorEvent(context, e));
        }
    }

    protected Event getAuthenticationFailureErrorEvent(RequestContext context, Exception exception) {
        return new EventFactorySupport().error((Object)this, exception);
    }

    @Generated
    protected AbstractCasWebflowEventResolver(CasWebflowEventResolutionConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public CasWebflowEventResolutionConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

