/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public final class URIUtils {
    private URIUtils() {
    }

    public static URI buildForConnId(String location) throws URISyntaxException {
        URI uri;
        String candidate = location.trim();
        if (!(candidate.startsWith("file:") || candidate.startsWith("connid:") || candidate.startsWith("connids:"))) {
            throw new IllegalArgumentException(candidate + " is not a valid URI for file or connid(s) schemes");
        }
        if (candidate.startsWith("file:")) {
            candidate = StringUtils.substringAfter((String)candidate, (String)"file:");
            if (SystemUtils.IS_OS_WINDOWS) {
                candidate = StringUtils.stripStart((String)candidate, (String)"/");
            }
            uri = Path.of(candidate, new String[0]).toFile().getAbsoluteFile().toURI();
        } else {
            uri = new URI(candidate);
        }
        return uri;
    }
}

