/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.panel;

import de.agilecoders.wicket.core.markup.html.bootstrap.panel.PanelType;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BorderBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.ColorBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.EnclosureContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BootstrapGenericPanel<T>
extends GenericPanel<T> {
    private static final String _PANEL_HEADER_ID = "panelHeader";
    private static final String _PANEL_TITLE_ID = "panelTitle";
    private static final String _PANEL_IMAGE_ID = "panelImageTop";
    private static final String _PANEL_BODY_ID = "panelBody";
    private static final String _PANEL_FOOTER_ID = "panelFooter";
    private final IModel<String> titleModel;
    private PanelType panelType;

    public BootstrapGenericPanel(String id) {
        this(id, null, null, null);
    }

    public BootstrapGenericPanel(String id, PanelType panelType) {
        this(id, null, null, panelType);
    }

    public BootstrapGenericPanel(String id, IModel<T> model, IModel<String> panelTitleModel) {
        this(id, model, panelTitleModel, null);
    }

    public BootstrapGenericPanel(String id, IModel<T> model, IModel<String> panelTitleModel, PanelType panelType) {
        super(id, model);
        this.titleModel = panelTitleModel;
        this.panelType = panelType;
    }

    public BootstrapGenericPanel<T> withPanelType(PanelType panelType) {
        this.panelType = panelType;
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        Label panelTitle = this.newTitleLabel(_PANEL_TITLE_ID, this.getModel(), this.getTitleModel());
        EnclosureContainer header = new EnclosureContainer(_PANEL_HEADER_ID, (Component)panelTitle);
        header.setRenderBodyOnly(false);
        header.add(new Component[]{panelTitle});
        this.add(new Component[]{header});
        Components.hideIfModelIsEmpty((Component)panelTitle);
        Component topImage = this.newTopImage(_PANEL_IMAGE_ID, this.getModel());
        this.add(new Component[]{topImage});
        Components.hideIfModelIsEmpty(topImage);
        Panel panelBody = this.newBodyPanel(_PANEL_BODY_ID, this.getModel());
        this.add(new Component[]{panelBody});
        Components.hideIfModelIsEmpty((Component)panelBody);
        Panel panelFooter = this.newFooterPanel(_PANEL_FOOTER_ID, this.getModel());
        this.add(new Component[]{panelFooter});
        Components.hideIfModelIsEmpty((Component)panelFooter);
        header.add(new Behavior[]{new BackgroundColorBehavior((IModel & Serializable)() -> this.panelType.getBackgroundColor()){

            public boolean isEnabled(Component component) {
                return BootstrapGenericPanel.this.isCustomPanelStyleSet();
            }
        }});
        header.add(new Behavior[]{new ColorBehavior((IModel & Serializable)() -> this.panelType.getTextColor()){

            public boolean isEnabled(Component component) {
                return BootstrapGenericPanel.this.isCustomPanelStyleSet();
            }
        }});
        this.add(new Behavior[]{new BorderBehavior(){

            public void onConfigure(Component component) {
                this.color(BootstrapGenericPanel.this.panelType.getBorderColor());
            }

            public boolean isEnabled(Component component) {
                return BootstrapGenericPanel.this.isCustomPanelStyleSet();
            }
        }.type(BorderBehavior.Type.All).radius(BorderBehavior.Radius.All)});
    }

    private boolean isCustomPanelStyleSet() {
        return !PanelType.Default.equals((Object)this.panelType) && this.panelType != null;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Components.assertTag((Component)this, tag, "div");
        Attributes.addClass(tag, "card");
    }

    public IModel<String> getTitleModel() {
        return this.titleModel;
    }

    protected Label newTitleLabel(String id, IModel<T> model, IModel<String> titleModel) {
        return new Label(id, titleModel);
    }

    protected Panel newBodyPanel(String id, IModel<T> model) {
        EmptyPanel emptyPanel = new EmptyPanel(id);
        emptyPanel.setDefaultModel((IModel)new Model());
        return emptyPanel;
    }

    protected Panel newFooterPanel(String id, IModel<T> model) {
        EmptyPanel emptyPanel = new EmptyPanel(id);
        emptyPanel.setDefaultModel((IModel)new Model());
        return emptyPanel;
    }

    protected Component newTopImage(String id, IModel<T> model) {
        EmptyPanel emptyTopImage = new EmptyPanel(id);
        emptyTopImage.setDefaultModel((IModel)new Model());
        return emptyTopImage;
    }
}

