/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import java.security.SecureRandom;
import java.util.Base64;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.DefaultCsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestAttributeHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class XorServerCsrfTokenRequestAttributeHandler
extends ServerCsrfTokenRequestAttributeHandler {
    private SecureRandom secureRandom = new SecureRandom();

    public void setSecureRandom(SecureRandom secureRandom) {
        Assert.notNull((Object)secureRandom, (String)"secureRandom cannot be null");
        this.secureRandom = secureRandom;
    }

    @Override
    public void handle(ServerWebExchange exchange, Mono<CsrfToken> csrfToken) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        Assert.notNull(csrfToken, (String)"csrfToken cannot be null");
        Mono updatedCsrfToken = csrfToken.map(token -> new DefaultCsrfToken(token.getHeaderName(), token.getParameterName(), XorServerCsrfTokenRequestAttributeHandler.createXoredCsrfToken(this.secureRandom, token.getToken()))).cast(CsrfToken.class).cache();
        super.handle(exchange, (Mono<CsrfToken>)updatedCsrfToken);
    }

    @Override
    public Mono<String> resolveCsrfTokenValue(ServerWebExchange exchange, CsrfToken csrfToken) {
        return super.resolveCsrfTokenValue(exchange, csrfToken).flatMap(actualToken -> Mono.justOrEmpty((Object)XorServerCsrfTokenRequestAttributeHandler.getTokenValue(actualToken, csrfToken.getToken())));
    }

    private static String getTokenValue(String actualToken, String token) {
        byte[] actualBytes;
        try {
            actualBytes = Base64.getUrlDecoder().decode(actualToken);
        }
        catch (Exception ex) {
            return null;
        }
        byte[] tokenBytes = Utf8.encode((CharSequence)token);
        int tokenSize = tokenBytes.length;
        if (actualBytes.length != tokenSize * 2) {
            return null;
        }
        byte[] xoredCsrf = new byte[tokenSize];
        byte[] randomBytes = new byte[tokenSize];
        System.arraycopy(actualBytes, 0, randomBytes, 0, tokenSize);
        System.arraycopy(actualBytes, tokenSize, xoredCsrf, 0, tokenSize);
        byte[] csrfBytes = XorServerCsrfTokenRequestAttributeHandler.xorCsrf(randomBytes, xoredCsrf);
        return csrfBytes != null ? Utf8.decode((byte[])csrfBytes) : null;
    }

    private static String createXoredCsrfToken(SecureRandom secureRandom, String token) {
        byte[] tokenBytes = Utf8.encode((CharSequence)token);
        byte[] randomBytes = new byte[tokenBytes.length];
        secureRandom.nextBytes(randomBytes);
        byte[] xoredBytes = XorServerCsrfTokenRequestAttributeHandler.xorCsrf(randomBytes, tokenBytes);
        byte[] combinedBytes = new byte[tokenBytes.length + randomBytes.length];
        System.arraycopy(randomBytes, 0, combinedBytes, 0, randomBytes.length);
        System.arraycopy(xoredBytes, 0, combinedBytes, randomBytes.length, xoredBytes.length);
        return Base64.getUrlEncoder().encodeToString(combinedBytes);
    }

    private static byte[] xorCsrf(byte[] randomBytes, byte[] csrfBytes) {
        Assert.isTrue((randomBytes.length == csrfBytes.length ? 1 : 0) != 0, (String)"arrays must be equal length");
        int len = csrfBytes.length;
        byte[] xoredCsrf = new byte[len];
        System.arraycopy(csrfBytes, 0, xoredCsrf, 0, len);
        for (int i = 0; i < len; ++i) {
            int n = i;
            xoredCsrf[n] = (byte)(xoredCsrf[n] ^ randomBytes[i]);
        }
        return xoredCsrf;
    }
}

