/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.widget.window;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.kendo.ui.KendoUIBehavior;
import org.wicketstuff.kendo.ui.widget.window.IWindowListener;
import org.wicketstuff.kendo.ui.widget.window.WindowBehavior;

public abstract class AbstractWindow<T>
extends GenericPanel<T>
implements IJQueryWidget,
IWindowListener {
    private static final long serialVersionUID = 1L;
    protected static final String ACTION_PIN = "pin";
    protected static final String ACTION_CLOSE = "close";
    protected static final String ACTION_REFRESH = "refresh";
    protected static final String ACTION_CUSTOM = "custom";
    protected static final String ACTION_MINIMIZE = "minimize";
    protected static final String ACTION_MAXIMIZE = "maximize";
    private static final int WIDTH = 450;
    private IModel<String> titleModel;
    private boolean modal;
    private WindowBehavior widgetBehavior = null;

    public AbstractWindow(String id, String title) {
        this(id, title, null, true);
    }

    public AbstractWindow(String id, IModel<String> title) {
        this(id, title, null, true);
    }

    public AbstractWindow(String id, String title, IModel<T> model) {
        this(id, title, model, true);
    }

    public AbstractWindow(String id, IModel<String> title, IModel<T> model) {
        this(id, title, model, true);
    }

    public AbstractWindow(String id, String title, boolean modal) {
        this(id, title, null, modal);
    }

    public AbstractWindow(String id, IModel<String> title, boolean modal) {
        this(id, title, null, modal);
    }

    public AbstractWindow(String id, String title, IModel<T> model, boolean modal) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), model, modal);
    }

    public AbstractWindow(String id, IModel<String> title, IModel<T> model, boolean modal) {
        super(id, model);
        this.titleModel = title;
        this.modal = modal;
    }

    public String widget() {
        return KendoUIBehavior.widget((Component)this, "kendoWindow");
    }

    public final void open(IPartialPageRequestHandler handler) {
        this.onOpen(handler);
        if (this.widgetBehavior != null) {
            this.widgetBehavior.open(handler);
        }
    }

    public final void close(IPartialPageRequestHandler handler) {
        if (this.widgetBehavior != null) {
            this.widgetBehavior.close(handler);
        }
        this.onClose(handler);
    }

    public int getWidth() {
        return 450;
    }

    public String getTitle() {
        return (String)this.titleModel.getObject();
    }

    public void setTitle(String title) {
        this.titleModel.setObject((Object)title);
    }

    public void setTitle(IPartialPageRequestHandler handler, String title) {
        this.setTitle(title);
        handler.appendJavaScript((CharSequence)String.format("%s.title(%s);", this.widgetBehavior.widget(), Options.asString((String)title)));
    }

    public IModel<String> getTitleModel() {
        return this.titleModel;
    }

    public void setTitleModel(IModel<String> model) {
        Args.notNull(model, (String)"model");
        this.titleModel = model;
    }

    public void setTitleModel(IPartialPageRequestHandler handler, IModel<String> model) {
        this.setTitleModel(model);
        handler.appendJavaScript((CharSequence)String.format("%s.title(%s);", this.widgetBehavior.widget(), Options.asString((String)((String)model.getObject()))));
    }

    public final boolean isModal() {
        return this.modal;
    }

    public boolean isCentered() {
        return true;
    }

    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean isActionEventEnabled() {
        return false;
    }

    @Override
    public boolean isCloseEventEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.widgetBehavior = (WindowBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this);
        this.add(new Behavior[]{this.widgetBehavior});
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("title", (Object)Options.asString((String)this.getTitle()));
        behavior.setOption("modal", (Object)this.isModal());
        behavior.setOption("resizable", (Object)this.isResizable());
        behavior.setOption("width", (Object)this.getWidth());
        behavior.setOption("visible", (Object)false);
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    protected void onOpen(IPartialPageRequestHandler handler) {
    }

    @Override
    public void onAction(AjaxRequestTarget target, String action) {
    }

    @Override
    public void onClose(IPartialPageRequestHandler handler) {
    }

    public WindowBehavior newWidgetBehavior(String selector) {
        return new WindowBehavior(selector, (IWindowListener)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isCentered() {
                return AbstractWindow.this.isCentered();
            }
        };
    }
}

