/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpLoader {
    private static final Logger logger = LoggerFactory.getLogger(OpLoader.class);
    private static final Map<String, OpProcessor> processors = new HashMap<String, OpProcessor>();
    private static volatile boolean initialized;

    public static synchronized void init(Settings settings) {
        if (!initialized) {
            processors.values().forEach(processor -> processor.init(settings));
            initialized = true;
        }
    }

    public static Optional<OpProcessor> getProcessor(String name) {
        return Optional.ofNullable(processors.get(name));
    }

    public static Map<String, OpProcessor> getProcessors() {
        return Collections.unmodifiableMap(processors);
    }

    public static synchronized void reset() {
        initialized = false;
    }

    static {
        ServiceLoader.load(OpProcessor.class).forEach(op -> {
            String name = op.getName();
            logger.info("Adding the {} OpProcessor.", (Object)(name.equals("") ? "standard" : name));
            if (processors.containsKey(name)) {
                throw new RuntimeException(String.format("There is a naming conflict with the %s OpProcessor implementations.", name));
            }
            processors.put(name, (OpProcessor)op);
        });
        initialized = false;
    }
}

