/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeServiceFacade;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.model.AppData;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.FieldAdapter;
import org.apache.fulcrum.parser.ValueParser;

@XmlType(name="group")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Group
implements Serializable,
LogEnabled {
    private static final long serialVersionUID = -5452725641409669284L;
    public static final String EMPTY = "";
    public static final String NEW = "_0";
    private transient Logger log;
    @XmlAttribute(name="key", required=true)
    private String gid;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute
    private int poolCapacity = 128;
    @XmlAttribute(name="mapToObject")
    private String defaultMapToObject;
    private AppData parent;
    private Map<String, Field<?>> fieldsByName;
    private Map<String, Field<?>[]> mapToObjectFields;
    private LinkedList<Field<?>> fields = new LinkedList();
    private String oid;
    private transient ValueParser pp;
    private boolean isDeclared;

    public void enableLogging(Logger logger) {
        this.log = logger.getChildLogger(this.getClass().getSimpleName());
    }

    public Group init(ValueParser pp) throws IntakeException {
        return this.init(NEW, pp);
    }

    public Group init(String key, ValueParser pp) throws IntakeException {
        this.oid = key;
        this.pp = pp;
        ListIterator<Field<?>> i = this.fields.listIterator(this.fields.size());
        while (i.hasPrevious()) {
            i.previous().init(pp);
        }
        i = this.fields.listIterator(this.fields.size());
        while (i.hasPrevious()) {
            Field<?> field = i.previous();
            if (!field.isSet() || field.isValidated()) continue;
            field.validate();
        }
        return this;
    }

    public Group init(Retrievable obj) {
        this.oid = obj.getQueryKey();
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field<?>[] flds = this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    flds[i].init(obj);
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field<?>[] interfaceFields = this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    interfaceFields[i].init(obj);
                }
            }
        }
        return this;
    }

    public String[] getFieldNames() {
        String[] nameList = new String[this.fields.size()];
        int i = 0;
        for (Field field : this.fields) {
            nameList[i++] = field.getName();
        }
        return nameList;
    }

    public String getIntakeGroupName() {
        return this.name;
    }

    public int getPoolCapacity() {
        return this.poolCapacity;
    }

    public String getGID() {
        return this.gid;
    }

    public String getOID() {
        return this.oid;
    }

    public String getObjectKey() {
        return this.gid + this.oid;
    }

    public String getDefaultMapToObject() {
        return this.defaultMapToObject;
    }

    public List<Group> getObjects(ValueParser pp) throws IntakeException {
        ArrayList<Group> objs = null;
        String[] oids = pp.getStrings(this.gid);
        if (oids != null) {
            objs = new ArrayList<Group>(oids.length);
            for (int i = oids.length - 1; i >= 0; --i) {
                objs.add(IntakeServiceFacade.getGroup(this.name).init(oids[i], pp));
            }
        }
        return objs;
    }

    public Field<?> get(String fieldName) throws IntakeException {
        if (this.fieldsByName.containsKey(fieldName)) {
            return this.fieldsByName.get(fieldName);
        }
        throw new IntakeException("Intake Field name: " + fieldName + " not found in Group " + this.name);
    }

    public List<Field<?>> getFields() {
        return this.fields;
    }

    @XmlElement(name="field")
    @XmlJavaTypeAdapter(value=FieldAdapter.class)
    protected void setFields(List<Field<?>> inputFields) {
        this.fields = new LinkedList(inputFields);
    }

    public boolean isAllValid() {
        boolean valid = true;
        ListIterator<Field<?>> i = this.fields.listIterator(this.fields.size());
        while (i.hasPrevious()) {
            Field<?> field = i.previous();
            valid &= field.isValid();
            if (!this.log.isDebugEnabled() || field.isValid()) continue;
            this.log.debug("Group(" + this.oid + "): " + this.name + "; Field: " + field.getName() + "; value=" + String.valueOf(field.getValue()) + " is invalid!");
        }
        return valid;
    }

    public void setProperties(Object obj) throws IntakeException {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field<?>[] flds;
            if (this.log.isDebugEnabled()) {
                this.log.debug("setProperties(" + cls.getName() + ")");
            }
            if ((flds = this.mapToObjectFields.get(cls.getName())) != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    flds[i].setProperty(obj);
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field<?>[] interfaceFields = this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    interfaceFields[i].setProperty(obj);
                }
            }
        }
        this.log.debug("setProperties() finished");
    }

    public void setValidProperties(Object obj) {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field<?>[] flds = this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    try {
                        flds[i].setProperty(obj);
                        continue;
                    }
                    catch (IntakeException intakeException) {
                        // empty catch block
                    }
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field<?>[] interfaceFields = this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    try {
                        interfaceFields[i].setProperty(obj);
                        continue;
                    }
                    catch (IntakeException intakeException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void getProperties(Object obj) throws IntakeException {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field<?>[] flds = this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    flds[i].getProperty(obj);
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field<?>[] interfaceFields = this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    interfaceFields[i].getProperty(obj);
                }
            }
        }
    }

    public void removeFromRequest() {
        String[] groups;
        if (this.pp != null && (groups = this.pp.getStrings(this.gid)) != null) {
            this.pp.remove(this.gid);
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i] == null || groups[i].equals(this.oid)) continue;
                this.pp.add(this.gid, groups[i]);
            }
            ListIterator<Field<?>> i = this.fields.listIterator(this.fields.size());
            while (i.hasPrevious()) {
                i.previous().removeFromRequest();
            }
        }
    }

    public void resetDeclared() {
        this.isDeclared = false;
    }

    public String getHtmlFormInput() {
        StringBuilder sb = new StringBuilder(64);
        this.appendHtmlFormInput(sb);
        return sb.toString();
    }

    public void appendHtmlFormInput(StringBuilder sb) {
        if (!this.isDeclared) {
            this.isDeclared = true;
            sb.append("<input type=\"hidden\" name=\"").append(this.gid).append("\" value=\"").append(this.oid).append("\"/>\n");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<group name=\"").append(this.getIntakeGroupName()).append("\"");
        result.append(" key=\"").append(this.getGID()).append("\"");
        result.append(">\n");
        if (this.fields != null) {
            for (Field field : this.fields) {
                result.append(field);
            }
        }
        result.append("</group>\n");
        return result.toString();
    }

    public AppData getAppData() {
        return this.parent;
    }

    public void afterUnmarshal(Unmarshaller um, Object parent) {
        this.parent = (AppData)parent;
        this.fieldsByName = new HashMap((int)(1.25 * (double)this.fields.size() + 1.0));
        for (Field field : this.fields) {
            this.fieldsByName.put(field.getName(), field);
        }
        HashMap<String, List> mapToObjectFieldLists = new HashMap<String, List>((int)(1.25 * (double)this.fields.size() + 1.0));
        for (Field field : this.fields) {
            if (StringUtils.isNotEmpty((CharSequence)field.mapToObject)) {
                field.mapToObject = this.parent.getBasePackage() + field.mapToObject;
            }
            List tmpFields = mapToObjectFieldLists.computeIfAbsent(field.getMapToObject(), k -> new ArrayList(this.fields.size()));
            tmpFields.add(field);
        }
        this.mapToObjectFields = new HashMap<String, Field<?>[]>((int)(1.25 * (double)this.fields.size() + 1.0));
        for (Map.Entry entry : mapToObjectFieldLists.entrySet()) {
            this.mapToObjectFields.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new Field[((List)entry.getValue()).size()]));
        }
    }

    public static class GroupFactory
    extends BaseKeyedPooledObjectFactory<String, Group> {
        private final AppData appData;

        public GroupFactory(AppData appData) {
            this.appData = appData;
        }

        public Group create(String key) throws IntakeException {
            return this.appData.getGroup(key);
        }

        public PooledObject<Group> wrap(Group group) {
            return new DefaultPooledObject((Object)group);
        }

        public void passivateObject(String key, PooledObject<Group> pooledGroup) {
            Group group = (Group)pooledGroup.getObject();
            group.oid = null;
            group.pp = null;
            ListIterator<Field<?>> i = group.fields.listIterator(group.fields.size());
            while (i.hasPrevious()) {
                i.previous().dispose();
            }
            group.isDeclared = false;
        }
    }
}

