/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.Valve;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.HttpUtils;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DetermineTargetValve
implements Valve {
    private static final Logger log = LogManager.getLogger(DetermineTargetValve.class);

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        RunData runData = pipelineData.getRunData();
        if (!runData.hasScreen()) {
            String target = runData.getParameters().getString("screen");
            if (target != null) {
                if (HttpUtils.keyRequiresClean(target)) {
                    String testAction = HttpUtils.getCleanedKey(target);
                    String message = "screen has invalid characters. ";
                    log.warn("{}. Debug action key: {}.", (Object)message, (Object)testAction);
                    throw new TurbineException(message);
                }
                runData.setScreen(target);
                log.debug("Set screen target from request parameter");
            } else {
                log.debug("No target screen");
            }
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = runData::getScreen;
        log.debug("Screen Target is now: {}", supplierArray);
        context.invokeNext(pipelineData);
    }
}

