/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.common.storage.StorageInfo;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.guava.collect.Maps;
import org.apache.uniffle.shaded.guava.collect.Sets;

public class ServerNode
implements Comparable<ServerNode> {
    private final Map<String, String> displayMetrics;
    private String id;
    private String ip;
    private int grpcPort;
    private long usedMemory;
    private long preAllocatedMemory;
    private long availableMemory;
    private int eventNumInFlush;
    private long registrationTime;
    private long timestamp;
    private Set<String> tags;
    private ServerStatus status;
    private Map<String, StorageInfo> storageInfo;
    private int nettyPort = -1;
    private int jettyPort = -1;
    private long startTime = -1L;
    private String version;
    private String gitCommitId;
    @JsonIgnore
    Map<String, RssProtos.ApplicationInfo> appIdToInfos;

    public ServerNode(String id) {
        this(id, "", 0, 0L, 0L, 0L, 0, Sets.newHashSet(), ServerStatus.EXCLUDED);
    }

    public ServerNode(String id, String ip, int port, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags) {
        this(id, ip, port, usedMemory, preAllocatedMemory, availableMemory, eventNumInFlush, tags, ServerStatus.ACTIVE, Maps.newHashMap());
    }

    public ServerNode(String id, String ip, int port, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags, ServerStatus status) {
        this(id, ip, port, usedMemory, preAllocatedMemory, availableMemory, eventNumInFlush, tags, status, Maps.newHashMap());
    }

    public ServerNode(String id, String ip, int port, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags, ServerStatus status, Map<String, StorageInfo> storageInfoMap) {
        this(id, ip, port, usedMemory, preAllocatedMemory, availableMemory, eventNumInFlush, tags, status, storageInfoMap, -1, -1, -1L);
    }

    public ServerNode(String id, String ip, int grpcPort, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags, ServerStatus status, Map<String, StorageInfo> storageInfoMap, int nettyPort) {
        this(id, ip, grpcPort, usedMemory, preAllocatedMemory, availableMemory, eventNumInFlush, tags, status, storageInfoMap, nettyPort, -1, -1L);
    }

    public ServerNode(String id, String ip, int grpcPort, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags, ServerStatus status, Map<String, StorageInfo> storageInfoMap, int nettyPort, int jettyPort, long startTime) {
        this(id, ip, grpcPort, usedMemory, preAllocatedMemory, availableMemory, eventNumInFlush, tags, status, storageInfoMap, nettyPort, jettyPort, startTime, "", "", Collections.EMPTY_LIST, Collections.EMPTY_MAP);
    }

    public ServerNode(String id, String ip, int grpcPort, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags, ServerStatus status, Map<String, StorageInfo> storageInfoMap, int nettyPort, int jettyPort, long startTime, String version, String gitCommitId, List<RssProtos.ApplicationInfo> appInfos, Map<String, String> displayMetrics) {
        this.id = id;
        this.ip = ip;
        this.grpcPort = grpcPort;
        this.usedMemory = usedMemory;
        this.preAllocatedMemory = preAllocatedMemory;
        this.availableMemory = availableMemory;
        this.eventNumInFlush = eventNumInFlush;
        this.timestamp = this.registrationTime = System.currentTimeMillis();
        this.tags = tags;
        this.status = status;
        this.storageInfo = storageInfoMap;
        if (nettyPort > 0) {
            this.nettyPort = nettyPort;
        }
        if (jettyPort > 0) {
            this.jettyPort = jettyPort;
        }
        this.startTime = startTime;
        this.version = version;
        this.gitCommitId = gitCommitId;
        this.appIdToInfos = new ConcurrentHashMap<String, RssProtos.ApplicationInfo>();
        appInfos.forEach(appInfo -> this.appIdToInfos.put(appInfo.getAppId(), (RssProtos.ApplicationInfo)appInfo));
        this.displayMetrics = displayMetrics;
    }

    public RssProtos.ShuffleServerId convertToGrpcProto() {
        return RssProtos.ShuffleServerId.newBuilder().setId(this.id).setIp(this.ip).setPort(this.grpcPort).setNettyPort(this.nettyPort).setJettyPort(this.jettyPort).build();
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getPreAllocatedMemory() {
        return this.preAllocatedMemory;
    }

    public long getAvailableMemory() {
        return this.availableMemory;
    }

    public int getEventNumInFlush() {
        return this.eventNumInFlush;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public void setStatus(ServerStatus serverStatus) {
        this.status = serverStatus;
    }

    public Map<String, StorageInfo> getStorageInfo() {
        return this.storageInfo;
    }

    public String toString() {
        return "ServerNode with id[" + this.id + "], ip[" + this.ip + "], grpc port[" + this.grpcPort + "], netty port[" + this.nettyPort + "], jettyPort[" + this.jettyPort + "], usedMemory[" + this.usedMemory + "], preAllocatedMemory[" + this.preAllocatedMemory + "], availableMemory[" + this.availableMemory + "], eventNumInFlush[" + this.eventNumInFlush + "], timestamp[" + this.timestamp + "], tags[" + this.tags.toString() + "], status[" + this.status + "], storages[num=" + this.storageInfo.size() + "], version[" + this.version + "], gitCommitId[" + this.gitCommitId + "]";
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    void setRegistrationTime(long registrationTime) {
        this.registrationTime = registrationTime;
    }

    public long getRegistrationTime() {
        return this.registrationTime;
    }

    @Override
    public int compareTo(ServerNode other) {
        if (this.availableMemory > other.getAvailableMemory()) {
            return -1;
        }
        if (this.availableMemory < other.getAvailableMemory()) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerNode) {
            return this.id.equals(((ServerNode)obj).getId());
        }
        return false;
    }

    public long getTotalMemory() {
        return this.availableMemory + this.usedMemory;
    }

    public int getNettyPort() {
        return this.nettyPort;
    }

    public int getJettyPort() {
        return this.jettyPort;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGitCommitId() {
        return this.gitCommitId;
    }

    public Map<String, RssProtos.ApplicationInfo> getAppIdToInfos() {
        return this.appIdToInfos;
    }

    public Map<String, String> getDisplayMetrics() {
        return this.displayMetrics;
    }
}

