/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.strategy.assignment;

import org.apache.uniffle.coordinator.ClusterManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.strategy.assignment.AssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.assignment.BasicAssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.assignment.PartitionBalanceAssignmentStrategy;

public class AssignmentStrategyFactory {
    private CoordinatorConf conf;
    private ClusterManager clusterManager;

    public AssignmentStrategyFactory(CoordinatorConf conf, ClusterManager clusterManager) {
        this.conf = conf;
        this.clusterManager = clusterManager;
    }

    public AssignmentStrategy getAssignmentStrategy() {
        StrategyName strategy = (StrategyName)((Object)this.conf.get(CoordinatorConf.COORDINATOR_ASSIGNMENT_STRATEGY));
        if (StrategyName.BASIC == strategy) {
            return new BasicAssignmentStrategy(this.clusterManager, this.conf);
        }
        if (StrategyName.PARTITION_BALANCE == strategy) {
            return new PartitionBalanceAssignmentStrategy(this.clusterManager, this.conf);
        }
        throw new UnsupportedOperationException("Unsupported assignment strategy.");
    }

    public static enum StrategyName {
        BASIC,
        PARTITION_BALANCE;

    }
}

