/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.web.resource;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.uniffle.common.web.resource.BaseResource;
import org.apache.uniffle.common.web.resource.Response;
import org.apache.uniffle.coordinator.AppInfo;
import org.apache.uniffle.coordinator.ApplicationManager;
import org.apache.uniffle.coordinator.CoordinatorServer;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.metric.CoordinatorMetrics;
import org.apache.uniffle.coordinator.web.vo.AppInfoVO;
import org.apache.uniffle.coordinator.web.vo.UserAppNumVO;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.guava.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public class ApplicationResource
extends BaseResource {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationResource.class);
    @Context
    protected ServletContext servletContext;

    @GET
    @Path(value="/total")
    public Response<Map<String, Integer>> getAppTotality() {
        return this.execute(() -> {
            HashMap<String, Integer> appTotalityMap = Maps.newHashMap();
            appTotalityMap.put("appCurrent", (int)CoordinatorMetrics.gaugeRunningAppNum.get());
            appTotalityMap.put("appTotality", (int)CoordinatorMetrics.counterTotalAppNum.get());
            return appTotalityMap;
        });
    }

    @GET
    @Path(value="/userTotal")
    public Response<List<UserAppNumVO>> getUserApps() {
        return this.execute(() -> {
            Map<String, Map<String, AppInfo>> currentUserAndApp = this.getApplicationManager().getCurrentUserAndApp();
            ArrayList<UserAppNumVO> usercnt = new ArrayList<UserAppNumVO>();
            for (Map.Entry<String, Map<String, AppInfo>> stringMapEntry : currentUserAndApp.entrySet()) {
                String userName = stringMapEntry.getKey();
                usercnt.add(new UserAppNumVO(userName, stringMapEntry.getValue().size()));
            }
            usercnt.sort(Comparator.reverseOrder());
            return usercnt;
        });
    }

    @GET
    @Path(value="/appInfos")
    public Response<List<AppInfoVO>> getAppInfoList() {
        return this.execute(() -> {
            ArrayList<AppInfoVO> userToAppList = new ArrayList<AppInfoVO>();
            Map<String, Map<String, AppInfo>> currentUserAndApp = this.getApplicationManager().getCurrentUserAndApp();
            List<ServerNode> serverNodes = this.getCoordinatorServer().getClusterManager().list();
            for (Map.Entry<String, Map<String, AppInfo>> userAppIdTimestampMap : currentUserAndApp.entrySet()) {
                for (Map.Entry<String, AppInfo> appIdTimestampMap : userAppIdTimestampMap.getValue().entrySet()) {
                    String user = appIdTimestampMap.getKey();
                    AppInfo appInfo = appIdTimestampMap.getValue();
                    AppInfoVO appInfoVO = new AppInfoVO(user, appInfo.getAppId(), appInfo.getUpdateTime(), appInfo.getRegistrationTime(), appInfo.getVersion(), appInfo.getGitCommitId(), 0L, 0L, 0L, 0L, 0L, 0L, 0L);
                    for (ServerNode server : serverNodes) {
                        Map<String, RssProtos.ApplicationInfo> appIdToInfos = server.getAppIdToInfos();
                        if (!appIdToInfos.containsKey(appInfoVO.getAppId())) continue;
                        RssProtos.ApplicationInfo app = appIdToInfos.get(appInfoVO.getAppId());
                        appInfoVO.setPartitionNum(appInfoVO.getPartitionNum() + app.getPartitionNum());
                        appInfoVO.setMemorySize(appInfoVO.getMemorySize() + app.getMemorySize());
                        appInfoVO.setLocalFileNum(appInfoVO.getLocalFileNum() + app.getLocalFileNum());
                        appInfoVO.setLocalTotalSize(appInfoVO.getLocalTotalSize() + app.getLocalTotalSize());
                        appInfoVO.setHadoopFileNum(appInfoVO.getHadoopFileNum() + app.getHadoopFileNum());
                        appInfoVO.setHadoopTotalSize(appInfoVO.getHadoopTotalSize() + app.getHadoopTotalSize());
                        appInfoVO.setTotalSize(appInfoVO.getTotalSize() + app.getTotalSize());
                    }
                    userToAppList.add(appInfoVO);
                }
            }
            userToAppList.sort(Comparator.reverseOrder());
            return userToAppList;
        });
    }

    private ApplicationManager getApplicationManager() {
        return (ApplicationManager)this.servletContext.getAttribute(ApplicationManager.class.getCanonicalName());
    }

    private CoordinatorServer getCoordinatorServer() {
        return (CoordinatorServer)this.servletContext.getAttribute(CoordinatorServer.class.getCanonicalName());
    }
}

