/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.buffer;

import io.netty.util.internal.PlatformDependent;
import io.prometheus.client.Histogram;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.uniffle.common.ReconfigurableConfManager;
import org.apache.uniffle.common.ReconfigurableRegistry;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.server.HugePartitionUtils;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleFlushManager;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleTaskManager;
import org.apache.uniffle.server.buffer.AbstractShuffleBuffer;
import org.apache.uniffle.server.buffer.ShuffleBuffer;
import org.apache.uniffle.server.buffer.ShuffleBufferType;
import org.apache.uniffle.server.buffer.ShuffleBufferWithLinkedList;
import org.apache.uniffle.server.buffer.ShuffleBufferWithSkipList;
import org.apache.uniffle.server.buffer.lab.ChunkCreator;
import org.apache.uniffle.server.buffer.lab.LABShuffleBufferWithLinkedList;
import org.apache.uniffle.server.buffer.lab.LABShuffleBufferWithSkipList;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.apache.uniffle.shaded.guava.collect.Maps;
import org.apache.uniffle.shaded.guava.collect.Range;
import org.apache.uniffle.shaded.guava.collect.RangeMap;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.apache.uniffle.shaded.guava.collect.TreeRangeMap;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleBufferManager {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleBufferManager.class);
    private final ShuffleBufferType shuffleBufferType;
    private final Boolean isLABEnabled;
    private final int flushTryLockTimeout;
    private final int maxFlushEventCountPerBuffer;
    private ShuffleTaskManager shuffleTaskManager;
    private final ShuffleFlushManager shuffleFlushManager;
    private long capacity;
    private long readCapacity;
    private long highWaterMark;
    private long lowWaterMark;
    private final boolean bufferFlushWhenCachingData;
    private boolean bufferFlushEnabled;
    private long bufferFlushThreshold;
    private long bufferFlushBlocksNumThreshold;
    private long shuffleFlushThreshold;
    private ReconfigurableConfManager.Reconfigurable<Long> hugePartitionSizeThresholdRef;
    private ReconfigurableConfManager.Reconfigurable<Long> hugePartitionSizeHardLimitRef;
    private ReconfigurableConfManager.Reconfigurable<Long> hugePartitionSplitLimitRef;
    private long hugePartitionMemoryLimitSize;
    protected AtomicLong preAllocatedSize = new AtomicLong(0L);
    protected AtomicLong inFlushSize = new AtomicLong(0L);
    protected AtomicLong usedMemory = new AtomicLong(0L);
    private AtomicLong readDataMemory = new AtomicLong(0L);
    protected Map<String, Map<Integer, RangeMap<Integer, ShuffleBuffer>>> bufferPool;
    protected Map<String, Map<Integer, AtomicLong>> shuffleSizeMap = JavaUtils.newConcurrentMap();
    private final boolean appBlockSizeMetricEnabled;
    private final ReentrantLock globalFlushLock = new ReentrantLock();

    public ShuffleBufferManager(ShuffleServerConf conf, ShuffleFlushManager shuffleFlushManager, boolean nettyServerEnabled) {
        long heapSize = Runtime.getRuntime().maxMemory();
        this.capacity = conf.getSizeAsBytes(ShuffleServerConf.SERVER_BUFFER_CAPACITY);
        if (this.capacity < 0L) {
            this.capacity = nettyServerEnabled ? (long)((double)NettyUtils.getMaxDirectMemory() * conf.getDouble(ShuffleServerConf.SERVER_BUFFER_CAPACITY_RATIO)) : (long)((double)heapSize * conf.getDouble(ShuffleServerConf.SERVER_BUFFER_CAPACITY_RATIO));
        }
        this.readCapacity = conf.getSizeAsBytes(ShuffleServerConf.SERVER_READ_BUFFER_CAPACITY);
        if (this.readCapacity < 0L) {
            this.readCapacity = nettyServerEnabled ? (long)((double)NettyUtils.getMaxDirectMemory() * conf.getDouble(ShuffleServerConf.SERVER_READ_BUFFER_CAPACITY_RATIO)) : (long)((double)heapSize * conf.getDouble(ShuffleServerConf.SERVER_READ_BUFFER_CAPACITY_RATIO));
        }
        LOG.info("Init shuffle buffer manager with capacity: {}, read buffer capacity: {}.", (Object)this.capacity, (Object)this.readCapacity);
        this.shuffleFlushManager = shuffleFlushManager;
        this.bufferPool = JavaUtils.newConcurrentMap();
        this.highWaterMark = (long)((double)this.capacity / 100.0 * (Double)conf.get(ShuffleServerConf.SERVER_MEMORY_SHUFFLE_HIGHWATERMARK_PERCENTAGE));
        this.lowWaterMark = (long)((double)this.capacity / 100.0 * (Double)conf.get(ShuffleServerConf.SERVER_MEMORY_SHUFFLE_LOWWATERMARK_PERCENTAGE));
        this.bufferFlushWhenCachingData = conf.getBoolean(ShuffleServerConf.BUFFER_FLUSH_TRIGGERED_WHEN_CACHEING_DATA);
        this.bufferFlushEnabled = conf.getBoolean(ShuffleServerConf.SINGLE_BUFFER_FLUSH_ENABLED);
        this.bufferFlushThreshold = conf.getSizeAsBytes(ShuffleServerConf.SINGLE_BUFFER_FLUSH_SIZE_THRESHOLD);
        this.bufferFlushBlocksNumThreshold = conf.getInteger(ShuffleServerConf.SINGLE_BUFFER_FLUSH_BLOCKS_NUM_THRESHOLD);
        this.shuffleFlushThreshold = conf.getSizeAsBytes(ShuffleServerConf.SERVER_SHUFFLE_FLUSH_THRESHOLD);
        this.hugePartitionSizeThresholdRef = conf.getReconfigurableConf(ShuffleServerConf.HUGE_PARTITION_SIZE_THRESHOLD);
        this.hugePartitionSizeHardLimitRef = conf.getReconfigurableConf(ShuffleServerConf.HUGE_PARTITION_SIZE_HARD_LIMIT);
        this.hugePartitionSplitLimitRef = conf.getReconfigurableConf(ShuffleServerConf.HUGE_PARTITION_SPLIT_LIMIT);
        this.hugePartitionMemoryLimitSize = Math.round((double)this.capacity * (Double)conf.get(ShuffleServerConf.HUGE_PARTITION_MEMORY_USAGE_LIMITATION_RATIO));
        this.appBlockSizeMetricEnabled = conf.getBoolean(ShuffleServerConf.APP_LEVEL_SHUFFLE_BLOCK_SIZE_METRIC_ENABLED);
        this.shuffleBufferType = (ShuffleBufferType)((Object)conf.get(ShuffleServerConf.SERVER_SHUFFLE_BUFFER_TYPE));
        this.flushTryLockTimeout = (Integer)conf.get(ShuffleServerConf.SERVER_SHUFFLE_FLUSH_TRYLOCK_TIMEOUT);
        ShuffleServerMetrics.addLabeledCacheGauge("block_count_in_buffer_pool", () -> this.bufferPool.values().stream().flatMap(innerMap -> innerMap.values().stream()).flatMap(rangeMap -> rangeMap.asMapOfRanges().values().stream()).mapToLong(shuffleBuffer -> shuffleBuffer.getBlockCount()).sum(), 120000L);
        ShuffleServerMetrics.addLabeledCacheGauge("in_flush_block_count_in_buffer_pool", () -> this.bufferPool.values().stream().flatMap(innerMap -> innerMap.values().stream()).flatMap(rangeMap -> rangeMap.asMapOfRanges().values().stream()).mapToLong(shuffleBuffer -> shuffleBuffer.getInFlushBlockCount()).sum(), 120000L);
        ShuffleServerMetrics.addLabeledCacheGauge("buffer_count_in_buffer_pool", () -> this.bufferPool.values().stream().flatMap(innerMap -> innerMap.values().stream()).mapToLong(rangeMap -> rangeMap.asMapOfRanges().size()).sum(), 120000L);
        ShuffleServerMetrics.addLabeledGauge("shuffle_count_in_buffer_pool", () -> this.bufferPool.values().stream().mapToLong(innerMap -> innerMap.size()).sum());
        ReconfigurableRegistry.register(Sets.newHashSet(ShuffleServerConf.SERVER_MEMORY_SHUFFLE_HIGHWATERMARK_PERCENTAGE.key(), ShuffleServerConf.SERVER_MEMORY_SHUFFLE_LOWWATERMARK_PERCENTAGE.key()), (theConf, changedProperties) -> {
            if (changedProperties == null) {
                return;
            }
            if (changedProperties.contains(ShuffleServerConf.SERVER_MEMORY_SHUFFLE_HIGHWATERMARK_PERCENTAGE.key())) {
                this.highWaterMark = (long)((double)this.capacity / 100.0 * (Double)conf.get(ShuffleServerConf.SERVER_MEMORY_SHUFFLE_HIGHWATERMARK_PERCENTAGE));
            }
            if (changedProperties.contains(ShuffleServerConf.SERVER_MEMORY_SHUFFLE_LOWWATERMARK_PERCENTAGE.key())) {
                this.lowWaterMark = (long)((double)this.capacity / 100.0 * (Double)conf.get(ShuffleServerConf.SERVER_MEMORY_SHUFFLE_LOWWATERMARK_PERCENTAGE));
            }
        });
        this.isLABEnabled = (Boolean)conf.get(ShuffleServerConf.SERVER_SHUFFLE_BUFFER_LAB_ENABLE);
        if (this.isLABEnabled.booleanValue()) {
            int chunkSize = (Integer)conf.get(ShuffleServerConf.SERVER_SHUFFLE_BUFFER_LAB_CHUNK_SIZE);
            double chunkPoolCapacityRatio = (Double)conf.get(ShuffleServerConf.SERVER_SHUFFLE_BUFFER_LAB_CHUNK_POOL_CAPACITY_RATIO);
            double maxAllocRatio = (Double)conf.get(ShuffleServerConf.SERVER_SHUFFLE_BUFFER_LAB_MAX_ALLOC_RATIO);
            int maxAlloc = (int)((double)chunkSize * maxAllocRatio);
            ChunkCreator.initialize(chunkSize, (long)((double)this.capacity * chunkPoolCapacityRatio), maxAlloc);
        }
        this.maxFlushEventCountPerBuffer = (Integer)conf.get(ShuffleServerConf.MAX_FLUSH_EVENT_COUNT_PER_BUFFER);
    }

    public void setShuffleTaskManager(ShuffleTaskManager taskManager) {
        this.shuffleTaskManager = taskManager;
    }

    public StatusCode registerBuffer(String appId, int shuffleId, int startPartition, int endPartition) {
        this.bufferPool.computeIfAbsent(appId, key -> JavaUtils.newConcurrentMap());
        Map<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers = this.bufferPool.get(appId);
        shuffleIdToBuffers.computeIfAbsent(shuffleId, key -> TreeRangeMap.create());
        RangeMap<Integer, ShuffleBuffer> bufferRangeMap = shuffleIdToBuffers.get(shuffleId);
        if (bufferRangeMap.get(startPartition) == null) {
            ShuffleServerMetrics.counterTotalPartitionNum.inc();
            ShuffleServerMetrics.gaugeTotalPartitionNum.inc();
            AbstractShuffleBuffer shuffleBuffer = this.shuffleBufferType == ShuffleBufferType.SKIP_LIST ? (this.isLABEnabled != false ? new LABShuffleBufferWithSkipList() : new ShuffleBufferWithSkipList()) : (this.isLABEnabled != false ? new LABShuffleBufferWithLinkedList() : new ShuffleBufferWithLinkedList());
            bufferRangeMap.put(Range.closed(startPartition, endPartition), shuffleBuffer);
        } else {
            LOG.warn("Already register for appId[" + appId + "], shuffleId[" + shuffleId + "], startPartition[" + startPartition + "], endPartition[" + endPartition + "]");
        }
        return StatusCode.SUCCESS;
    }

    public StatusCode cacheShuffleData(String appId, int shuffleId, boolean isPreAllocated, ShufflePartitionedData spd) {
        if (!isPreAllocated && this.isFull()) {
            LOG.warn("Got unexpected data, can't cache it because the space is full");
            return StatusCode.NO_BUFFER;
        }
        Map.Entry<Range<Integer>, ShuffleBuffer> entry = this.getShuffleBufferEntry(appId, shuffleId, spd.getPartitionId());
        if (entry == null) {
            return StatusCode.NO_REGISTER;
        }
        ShuffleBuffer buffer = entry.getValue();
        long size = buffer.append(spd);
        if (size == -1L) {
            return StatusCode.NO_REGISTER;
        }
        if (!isPreAllocated) {
            this.updateUsedMemory(size);
        }
        if (this.appBlockSizeMetricEnabled) {
            Arrays.stream(spd.getBlockList()).forEach(b -> {
                int blockSize = b.getDataLength();
                ((Histogram.Child)ShuffleServerMetrics.appHistogramWriteBlockSize.labels(new String[]{appId})).observe((double)blockSize);
            });
        }
        LOG.debug("cache shuffle data, size: {}, blockCount: {}, appId: {}, shuffleId: {}, partitionId: {}", new Object[]{spd.getTotalBlockDataLength(), spd.getBlockList().length, appId, shuffleId, spd.getPartitionId()});
        this.updateShuffleSize(appId, shuffleId, size);
        this.flushSingleBufferIfNecessary(buffer, appId, shuffleId, spd.getPartitionId(), entry.getKey().lowerEndpoint(), entry.getKey().upperEndpoint());
        if (this.bufferFlushWhenCachingData && this.needToFlush()) {
            this.flushIfNecessary();
        }
        return StatusCode.SUCCESS;
    }

    private void updateShuffleSize(String appId, int shuffleId, long size) {
        this.shuffleSizeMap.computeIfAbsent(appId, key -> JavaUtils.newConcurrentMap());
        Map<Integer, AtomicLong> shuffleIdToSize = this.shuffleSizeMap.get(appId);
        shuffleIdToSize.computeIfAbsent(shuffleId, key -> new AtomicLong(0L));
        shuffleIdToSize.get(shuffleId).addAndGet(size);
    }

    public Map.Entry<Range<Integer>, ShuffleBuffer> getShuffleBufferEntry(String appId, int shuffleId, int partitionId) {
        Map<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers = this.bufferPool.get(appId);
        if (shuffleIdToBuffers == null) {
            return null;
        }
        RangeMap<Integer, ShuffleBuffer> rangeToBuffers = shuffleIdToBuffers.get(shuffleId);
        if (rangeToBuffers == null) {
            return null;
        }
        Map.Entry<Range<Integer>, ShuffleBuffer> entry = rangeToBuffers.getEntry(partitionId);
        if (entry == null) {
            return null;
        }
        return entry;
    }

    public ShuffleDataResult getShuffleData(String appId, int shuffleId, int partitionId, long blockId, int readBufferSize) {
        return this.getShuffleData(appId, shuffleId, partitionId, blockId, readBufferSize, null);
    }

    public ShuffleDataResult getShuffleData(String appId, int shuffleId, int partitionId, long blockId, int readBufferSize, Roaring64NavigableMap expectedTaskIds) {
        Map.Entry<Range<Integer>, ShuffleBuffer> entry = this.getShuffleBufferEntry(appId, shuffleId, partitionId);
        if (entry == null) {
            return null;
        }
        ShuffleBuffer buffer = entry.getValue();
        if (buffer == null) {
            return null;
        }
        return buffer.getShuffleData(blockId, readBufferSize, expectedTaskIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushSingleBufferIfNecessary(ShuffleBuffer buffer, String appId, int shuffleId, int partitionId, int startPartition, int endPartition) {
        if (buffer.getEncodedLength() <= this.bufferFlushThreshold && (long)buffer.getBlockCount() <= this.bufferFlushBlocksNumThreshold) {
            return;
        }
        boolean isHugePartition = HugePartitionUtils.isHugePartition(this.shuffleTaskManager, appId, shuffleId, partitionId);
        if (!isHugePartition && !this.bufferFlushEnabled) {
            return;
        }
        ShuffleBuffer shuffleBuffer = buffer;
        synchronized (shuffleBuffer) {
            if (buffer.getEncodedLength() > this.bufferFlushThreshold || (long)buffer.getBlockCount() > this.bufferFlushBlocksNumThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Start to flush single buffer. Details - shuffleId:{}, startPartition:{}, endPartition:{}, isHugePartition:{}, bufferSize:{}, blocksNum:{}", new Object[]{shuffleId, startPartition, endPartition, isHugePartition, buffer.getEncodedLength(), buffer.getBlockCount()});
                }
                this.flushBuffer(buffer, appId, shuffleId, startPartition, endPartition, isHugePartition);
            }
        }
    }

    public boolean needToFlush() {
        return this.usedMemory.get() - this.preAllocatedSize.get() - this.inFlushSize.get() > this.highWaterMark;
    }

    public void flushIfNecessary() {
        boolean lockAcquired = false;
        try {
            lockAcquired = this.globalFlushLock.tryLock(this.flushTryLockTimeout, TimeUnit.MILLISECONDS);
            if (!lockAcquired) {
                return;
            }
            if (this.needToFlush()) {
                LOG.info("Start to flush with usedMemory[{}], preAllocatedSize[{}], inFlushSize[{}]", new Object[]{this.usedMemory.get(), this.preAllocatedSize.get(), this.inFlushSize.get()});
                Map<String, Set<Integer>> pickedShuffle = this.pickFlushedShuffle();
                this.flush(pickedShuffle);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Ignore the InterruptedException which should be caused by internal killed");
        }
        finally {
            if (lockAcquired) {
                this.globalFlushLock.unlock();
            }
        }
    }

    public synchronized void commitShuffleTask(String appId, int shuffleId) {
        RangeMap<Integer, ShuffleBuffer> buffers = this.bufferPool.get(appId).get(shuffleId);
        for (Map.Entry<Range<Integer>, ShuffleBuffer> entry : buffers.asMapOfRanges().entrySet()) {
            ShuffleBuffer buffer = entry.getValue();
            Range<Integer> range = entry.getKey();
            this.flushBuffer(buffer, appId, shuffleId, range.lowerEndpoint(), range.upperEndpoint(), HugePartitionUtils.isHugePartition(this.shuffleTaskManager, appId, shuffleId, range.lowerEndpoint()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flushBuffer(ShuffleBuffer buffer, String appId, int shuffleId, int startPartition, int endPartition, boolean isHugePartition) {
        ReentrantReadWriteLock.ReadLock readLock = this.shuffleTaskManager.getAppReadLock(appId);
        readLock.lock();
        try {
            if (!((Map)this.bufferPool.getOrDefault(appId, new HashMap())).containsKey(shuffleId)) {
                LOG.info("Shuffle[{}] for app[{}] has already been removed, no need to flush the buffer", (Object)shuffleId, (Object)appId);
                boolean bl = false;
                return bl;
            }
            int flushEventCount = buffer.getInFlushEventCount();
            if (this.maxFlushEventCountPerBuffer > 0 && flushEventCount >= this.maxFlushEventCountPerBuffer) {
                LOG.warn("Shuffle[{}] for app[{}] already has [{}] flush events, ignore it.", new Object[]{shuffleId, appId, flushEventCount});
                boolean bl = false;
                return bl;
            }
            ShuffleDataFlushEvent event = buffer.toFlushEvent(appId, shuffleId, startPartition, endPartition, () -> ((Map)this.bufferPool.getOrDefault(appId, new HashMap())).containsKey(shuffleId), this.shuffleFlushManager.getDataDistributionType(appId));
            if (event != null) {
                event.addCleanupCallback(() -> this.releaseMemory(event.getEncodedLength(), true, false));
                this.updateShuffleSize(appId, shuffleId, -event.getEncodedLength());
                this.inFlushSize.addAndGet(event.getEncodedLength());
                if (isHugePartition) {
                    event.markOwnedByHugePartition();
                }
                ShuffleServerMetrics.gaugeInFlushBufferSize.set((double)this.inFlushSize.get());
                this.shuffleFlushManager.addToFlushQueue(event);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            readLock.unlock();
        }
        return false;
    }

    public void removeBuffer(String appId) {
        Map<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers = this.bufferPool.get(appId);
        if (shuffleIdToBuffers == null) {
            return;
        }
        this.removeBufferByShuffleId(appId, shuffleIdToBuffers.keySet());
        this.shuffleSizeMap.remove(appId);
        this.bufferPool.remove(appId);
        if (this.appBlockSizeMetricEnabled) {
            ShuffleServerMetrics.appHistogramWriteBlockSize.remove(new String[]{appId});
        }
    }

    public synchronized boolean requireMemory(long size, boolean isPreAllocated) {
        if (this.capacity - this.usedMemory.get() >= size) {
            this.usedMemory.addAndGet(size);
            ShuffleServerMetrics.gaugeUsedBufferSize.set((double)this.usedMemory.get());
            if (isPreAllocated) {
                this.requirePreAllocatedSize(size);
            }
            if (LOG.isDebugEnabled()) {
                long usedDirectMemory = PlatformDependent.usedDirectMemory();
                long usedHeapMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                LOG.debug("Require memory succeeded with " + size + " bytes, usedMemory[" + this.usedMemory.get() + "] include preAllocation[" + this.preAllocatedSize.get() + "], inFlushSize[" + this.inFlushSize.get() + "], usedDirectMemory[" + usedDirectMemory + "], usedHeapMemory[" + usedHeapMemory + "]");
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Require memory failed with " + size + " bytes, usedMemory[" + this.usedMemory.get() + "] include preAllocation[" + this.preAllocatedSize.get() + "], inFlushSize[" + this.inFlushSize.get() + "]");
        }
        return false;
    }

    public void releaseMemory(long size, boolean isReleaseFlushMemory, boolean isReleasePreAllocation) {
        if (this.usedMemory.get() >= size) {
            this.usedMemory.addAndGet(-size);
        } else {
            LOG.warn("Current allocated memory[" + this.usedMemory.get() + "] is less than released[" + size + "], set allocated memory to 0");
            this.usedMemory.set(0L);
        }
        ShuffleServerMetrics.gaugeUsedBufferSize.set((double)this.usedMemory.get());
        if (isReleaseFlushMemory) {
            this.releaseFlushMemory(size);
        }
        if (isReleasePreAllocation) {
            this.releasePreAllocatedSize(size);
        }
    }

    private void releaseFlushMemory(long size) {
        if (this.inFlushSize.get() >= size) {
            this.inFlushSize.addAndGet(-size);
        } else {
            LOG.warn("Current in flush memory[" + this.inFlushSize.get() + "] is less than released[" + size + "], set in flush memory to 0");
            this.inFlushSize.set(0L);
        }
        ShuffleServerMetrics.gaugeInFlushBufferSize.set((double)this.inFlushSize.get());
    }

    public boolean requireReadMemory(long size) {
        long currentReadDataMemory;
        long newReadDataMemory;
        ShuffleServerMetrics.counterTotalRequireReadMemoryNum.inc();
        boolean isSuccessful = false;
        while ((newReadDataMemory = (currentReadDataMemory = this.readDataMemory.get()) + size) < this.readCapacity) {
            if (!this.readDataMemory.compareAndSet(currentReadDataMemory, newReadDataMemory)) continue;
            ShuffleServerMetrics.gaugeReadBufferUsedSize.inc((double)size);
            isSuccessful = true;
            break;
        }
        if (!isSuccessful) {
            LOG.warn("Can't require[" + size + "] for read data, current[" + this.readDataMemory.get() + "], capacity[" + this.readCapacity + "]");
            ShuffleServerMetrics.counterTotalRequireReadMemoryRetryNum.inc();
            ShuffleServerMetrics.counterTotalRequireReadMemoryFailedNum.inc();
        }
        return isSuccessful;
    }

    public void releaseReadMemory(long size) {
        if (this.readDataMemory.get() >= size) {
            this.readDataMemory.addAndGet(-size);
            ShuffleServerMetrics.gaugeReadBufferUsedSize.dec((double)size);
        } else {
            LOG.warn("Current read memory[" + this.readDataMemory.get() + "] is less than released[" + size + "], set read memory to 0");
            this.readDataMemory.set(0L);
            ShuffleServerMetrics.gaugeReadBufferUsedSize.set(0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flush(Map<String, Set<Integer>> requiredFlush) {
        long pickedFlushSize = 0L;
        long expectedFlushSize = this.highWaterMark - this.lowWaterMark;
        for (Map.Entry<String, Map<Integer, RangeMap<Integer, ShuffleBuffer>>> appIdToBuffers : this.bufferPool.entrySet()) {
            String appId = appIdToBuffers.getKey();
            if (!requiredFlush.containsKey(appId) || this.shuffleTaskManager.isAppExpired(appId)) continue;
            ReentrantReadWriteLock.ReadLock readLock = this.shuffleTaskManager.getAppReadLock(appId);
            boolean lockAcquired = false;
            try {
                lockAcquired = readLock.tryLock(this.flushTryLockTimeout, TimeUnit.MILLISECONDS);
                if (!lockAcquired) continue;
                for (Map.Entry<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers : appIdToBuffers.getValue().entrySet()) {
                    int shuffleId = shuffleIdToBuffers.getKey();
                    Set<Integer> requiredShuffleId = requiredFlush.get(appId);
                    if (requiredShuffleId == null || !requiredShuffleId.contains(shuffleId)) continue;
                    for (Map.Entry<Range<Integer>, ShuffleBuffer> rangeEntry : shuffleIdToBuffers.getValue().asMapOfRanges().entrySet()) {
                        Range<Integer> range = rangeEntry.getKey();
                        ShuffleBuffer shuffleBuffer = rangeEntry.getValue();
                        long bufferEncodedLength = shuffleBuffer.getEncodedLength();
                        boolean success = this.flushBuffer(shuffleBuffer, appId, shuffleId, range.lowerEndpoint(), range.upperEndpoint(), HugePartitionUtils.isHugePartition(this.shuffleTaskManager, appId, shuffleId, range.lowerEndpoint()));
                        if (success) {
                            pickedFlushSize += bufferEncodedLength;
                        }
                        if (pickedFlushSize <= expectedFlushSize) continue;
                        LOG.info("Already picked enough buffers to flush {} bytes", (Object)pickedFlushSize);
                        return;
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Ignore the InterruptedException which should be caused by internal killed");
            }
            finally {
                if (!lockAcquired) continue;
                readLock.unlock();
            }
        }
    }

    public void updateUsedMemory(long delta) {
        this.usedMemory.addAndGet(delta);
        ShuffleServerMetrics.gaugeUsedBufferSize.set((double)this.usedMemory.get());
    }

    void requirePreAllocatedSize(long delta) {
        this.preAllocatedSize.addAndGet(delta);
        ShuffleServerMetrics.gaugeAllocatedBufferSize.set((double)this.preAllocatedSize.get());
    }

    public void releasePreAllocatedSize(long delta) {
        if (this.preAllocatedSize.get() >= delta) {
            this.preAllocatedSize.addAndGet(-delta);
        } else {
            LOG.warn("Current pre-allocated memory[" + this.preAllocatedSize.get() + "] is less than released[" + delta + "], set pre-allocated memory to 0");
            this.preAllocatedSize.set(0L);
        }
        ShuffleServerMetrics.gaugeAllocatedBufferSize.set((double)this.preAllocatedSize.get());
    }

    boolean isFull() {
        return this.usedMemory.get() >= this.capacity;
    }

    @VisibleForTesting
    public Map<String, Map<Integer, RangeMap<Integer, ShuffleBuffer>>> getBufferPool() {
        return this.bufferPool;
    }

    @VisibleForTesting
    public ShuffleBuffer getShuffleBuffer(String appId, int shuffleId, int partitionId) {
        return this.getShuffleBufferEntry(appId, shuffleId, partitionId).getValue();
    }

    public long getUsedMemory() {
        return this.usedMemory.get();
    }

    public long getInFlushSize() {
        return this.inFlushSize.get();
    }

    public long getCapacity() {
        return this.capacity;
    }

    @VisibleForTesting
    public long getReadCapacity() {
        return this.readCapacity;
    }

    @VisibleForTesting
    public void resetSize() {
        this.usedMemory = new AtomicLong(0L);
        this.preAllocatedSize = new AtomicLong(0L);
        this.inFlushSize = new AtomicLong(0L);
    }

    @VisibleForTesting
    public Map<String, Map<Integer, AtomicLong>> getShuffleSizeMap() {
        return this.shuffleSizeMap;
    }

    public long getPreAllocatedSize() {
        return this.preAllocatedSize.get();
    }

    private Map<String, Set<Integer>> pickFlushedShuffle() {
        List<Map.Entry<String, AtomicLong>> sizeList = this.generateSizeList();
        sizeList.sort((entry1, entry2) -> {
            if (entry1 == null && entry2 == null) {
                return 0;
            }
            if (entry1 == null) {
                return 1;
            }
            if (entry2 == null) {
                return -1;
            }
            if (((AtomicLong)entry1.getValue()).get() > ((AtomicLong)entry2.getValue()).get()) {
                return -1;
            }
            if (((AtomicLong)entry1.getValue()).get() == ((AtomicLong)entry2.getValue()).get()) {
                return 0;
            }
            return 1;
        });
        HashMap<String, Set<Integer>> pickedShuffle = Maps.newHashMap();
        long expectedFlushSize = this.highWaterMark - this.lowWaterMark;
        long atLeastFlushSizeIgnoreThreshold = expectedFlushSize >>> 1;
        long pickedFlushSize = 0L;
        int printIndex = 0;
        int printIgnoreIndex = 0;
        int printMax = 10;
        for (Map.Entry<String, AtomicLong> entry : sizeList) {
            long size = entry.getValue().get();
            String appIdShuffleIdKey = entry.getKey();
            if (size > this.shuffleFlushThreshold || pickedFlushSize <= atLeastFlushSizeIgnoreThreshold) {
                pickedFlushSize += size;
                this.addPickedShuffle(appIdShuffleIdKey, pickedShuffle);
                if (printIndex < printMax) {
                    LOG.info("Pick application_shuffleId[{}] with {} bytes", (Object)appIdShuffleIdKey, (Object)size);
                    ++printIndex;
                }
                if (pickedFlushSize <= expectedFlushSize) continue;
                LOG.info("Finish flush pick with {} bytes", (Object)pickedFlushSize);
                break;
            }
            if (printIgnoreIndex >= printMax) break;
            LOG.info("Ignore application_shuffleId[{}] with {} bytes", (Object)appIdShuffleIdKey, (Object)size);
            ++printIgnoreIndex;
        }
        return pickedShuffle;
    }

    private List<Map.Entry<String, AtomicLong>> generateSizeList() {
        HashMap<String, AtomicLong> sizeMap = Maps.newHashMap();
        for (Map.Entry<String, Map<Integer, AtomicLong>> appEntry : this.shuffleSizeMap.entrySet()) {
            String appId = appEntry.getKey();
            for (Map.Entry<Integer, AtomicLong> shuffleEntry : appEntry.getValue().entrySet()) {
                Integer shuffleId = shuffleEntry.getKey();
                sizeMap.put(RssUtils.generateShuffleKey((String)appId, (int)shuffleId), shuffleEntry.getValue());
            }
        }
        return Lists.newArrayList(sizeMap.entrySet());
    }

    private void addPickedShuffle(String shuffleIdKey, Map<String, Set<Integer>> pickedShuffle) {
        String[] splits = shuffleIdKey.split("/");
        String appId = splits[0];
        Integer shuffleId = Integer.parseInt(splits[1]);
        pickedShuffle.computeIfAbsent(appId, key -> Sets.newHashSet());
        Set<Integer> shuffleIdSet = pickedShuffle.get(appId);
        shuffleIdSet.add(shuffleId);
    }

    public void removeBufferByShuffleId(String appId, Collection<Integer> shuffleIds) {
        Map<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers = this.bufferPool.get(appId);
        if (shuffleIdToBuffers == null) {
            return;
        }
        Map<Integer, AtomicLong> shuffleIdToSizeMap = this.shuffleSizeMap.get(appId);
        for (int shuffleId : shuffleIds) {
            RangeMap<Integer, ShuffleBuffer> bufferRangeMap = shuffleIdToBuffers.remove(shuffleId);
            if (bufferRangeMap == null) continue;
            Collection<ShuffleBuffer> buffers = bufferRangeMap.asMapOfRanges().values();
            if (buffers != null) {
                for (ShuffleBuffer buffer : buffers) {
                    long releasedSize = buffer.release();
                    ShuffleServerMetrics.gaugeTotalPartitionNum.dec();
                    if (releasedSize != buffer.getEncodedLength()) {
                        LOG.warn("Release shuffle buffer size {} is not equal to buffer size {}, appId: {}, shuffleId: {}", new Object[]{releasedSize, buffer.getEncodedLength(), appId, shuffleId});
                    }
                    this.releaseMemory(releasedSize, false, false);
                }
            }
            if (shuffleIdToSizeMap == null) continue;
            shuffleIdToSizeMap.remove(shuffleId);
        }
    }

    public long getHugePartitionSizeHardLimit() {
        return this.hugePartitionSizeHardLimitRef.getSizeAsBytes();
    }

    public long getHugePartitionSizeThreshold() {
        return this.hugePartitionSizeThresholdRef.getSizeAsBytes();
    }

    public long getHugePartitionMemoryLimitSize() {
        return this.hugePartitionMemoryLimitSize;
    }

    public void setUsedMemory(long usedMemory) {
        this.usedMemory.set(usedMemory);
    }

    @VisibleForTesting
    public void setBufferFlushThreshold(long bufferFlushThreshold) {
        this.bufferFlushThreshold = bufferFlushThreshold;
    }

    public ShuffleBufferType getShuffleBufferType() {
        return this.shuffleBufferType;
    }

    public long getHugePartitionSplitLimit() {
        return this.hugePartitionSplitLimitRef.getSizeAsBytes();
    }
}

