/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.merge;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.merge.MergeEvent;
import org.apache.uniffle.server.merge.MergeEventHandler;
import org.apache.uniffle.shaded.guava.collect.Queues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMergeEventHandler
implements MergeEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMergeEventHandler.class);
    private Executor threadPoolExecutor;
    protected final BlockingQueue<MergeEvent> queue = Queues.newLinkedBlockingQueue();
    private Consumer<MergeEvent> eventConsumer;
    private volatile boolean stopped = false;

    public DefaultMergeEventHandler(ShuffleServerConf serverConf, Consumer<MergeEvent> eventConsumer) {
        this.eventConsumer = eventConsumer;
        int poolSize = (Integer)serverConf.get(ShuffleServerConf.SERVER_MERGE_THREAD_POOL_SIZE);
        int queueSize = (Integer)serverConf.get(ShuffleServerConf.SERVER_MERGE_THREAD_POOL_QUEUE_SIZE);
        int keepAliveTime = (Integer)serverConf.get(ShuffleServerConf.SERVER_MERGE_THREAD_ALIVE_TIME);
        LinkedBlockingQueue<Runnable> waitQueue = Queues.newLinkedBlockingQueue(queueSize);
        this.threadPoolExecutor = new ThreadPoolExecutor(poolSize, poolSize, (long)keepAliveTime, TimeUnit.SECONDS, waitQueue, ThreadUtils.getThreadFactory((String)"DefaultMergeEventHandler"));
        this.startEventProcessor();
    }

    private void startEventProcessor() {
        Thread processEventThread = new Thread(this::eventLoop);
        processEventThread.setName("ProcessEventThread");
        processEventThread.setDaemon(true);
        processEventThread.start();
    }

    protected void eventLoop() {
        while (!this.stopped && !Thread.currentThread().isInterrupted()) {
            this.processNextEvent();
        }
    }

    protected void processNextEvent() {
        try {
            MergeEvent event = this.queue.take();
            this.threadPoolExecutor.execute(() -> this.handleEventAndUpdateMetrics(event));
        }
        catch (Exception e) {
            LOG.error("Exception happened when process event.", (Throwable)e);
        }
    }

    private void handleEventAndUpdateMetrics(MergeEvent event) {
        try {
            this.eventConsumer.accept(event);
        }
        finally {
            ShuffleServerMetrics.gaugeMergeEventQueueSize.dec();
        }
    }

    @Override
    public boolean handle(MergeEvent event) {
        if (this.queue.offer(event)) {
            ShuffleServerMetrics.gaugeMergeEventQueueSize.inc();
            return true;
        }
        return false;
    }

    @Override
    public int getEventNumInMerge() {
        return this.queue.size();
    }

    @Override
    public void stop() {
        this.stopped = true;
    }
}

