/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.request;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.proto.RssProtos;

public class RssRegisterShuffleRequest {
    private String appId;
    private int shuffleId;
    private List<PartitionRange> partitionRanges;
    private RemoteStorageInfo remoteStorageInfo;
    private String user;
    private ShuffleDataDistributionType dataDistributionType;
    private int maxConcurrencyPerPartitionToWrite;
    private final RssProtos.MergeContext mergeContext;
    private Map<String, String> properties;

    @VisibleForTesting
    public RssRegisterShuffleRequest(String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorageInfo, String user, ShuffleDataDistributionType dataDistributionType, int maxConcurrencyPerPartitionToWrite) {
        this(appId, shuffleId, partitionRanges, remoteStorageInfo, user, dataDistributionType, maxConcurrencyPerPartitionToWrite, null, Collections.emptyMap());
    }

    public RssRegisterShuffleRequest(String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorageInfo, String user, ShuffleDataDistributionType dataDistributionType, int maxConcurrencyPerPartitionToWrite, RssProtos.MergeContext mergeContext, Map<String, String> properties) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionRanges = partitionRanges;
        this.remoteStorageInfo = remoteStorageInfo;
        this.user = user;
        this.dataDistributionType = dataDistributionType;
        this.maxConcurrencyPerPartitionToWrite = maxConcurrencyPerPartitionToWrite;
        this.mergeContext = mergeContext;
        this.properties = properties;
    }

    @VisibleForTesting
    public RssRegisterShuffleRequest(String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorageInfo, String user, ShuffleDataDistributionType dataDistributionType) {
        this(appId, shuffleId, partitionRanges, remoteStorageInfo, user, dataDistributionType, (Integer)RssClientConf.MAX_CONCURRENCY_PER_PARTITION_TO_WRITE.defaultValue(), null, Collections.emptyMap());
    }

    public RssRegisterShuffleRequest(String appId, int shuffleId, List<PartitionRange> partitionRanges, String remoteStoragePath) {
        this(appId, shuffleId, partitionRanges, new RemoteStorageInfo(remoteStoragePath), "", ShuffleDataDistributionType.NORMAL, (Integer)RssClientConf.MAX_CONCURRENCY_PER_PARTITION_TO_WRITE.defaultValue(), null, Collections.emptyMap());
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public List<PartitionRange> getPartitionRanges() {
        return this.partitionRanges;
    }

    public RemoteStorageInfo getRemoteStorageInfo() {
        return this.remoteStorageInfo;
    }

    public String getUser() {
        return this.user;
    }

    public ShuffleDataDistributionType getDataDistributionType() {
        return this.dataDistributionType;
    }

    public int getMaxConcurrencyPerPartitionToWrite() {
        return this.maxConcurrencyPerPartitionToWrite;
    }

    public RssProtos.MergeContext getMergeContext() {
        return this.mergeContext;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

