/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleDataSegment;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.storage.handler.impl.DataSkippableReadHandler;
import org.apache.uniffle.storage.handler.impl.HadoopFileReader;
import org.apache.uniffle.storage.handler.impl.PrefetchableClientReadHandler;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopShuffleReadHandler
extends DataSkippableReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopShuffleReadHandler.class);
    protected final String filePrefix;
    protected final HadoopFileReader indexReader;
    protected final HadoopFileReader dataReader;
    protected final boolean offHeapEnabled;

    public HadoopShuffleReadHandler(String appId, int shuffleId, int partitionId, String filePrefix, int readBufferSize, Roaring64NavigableMap expectBlockIds, Set<Long> processBlockIds, Configuration conf, ShuffleDataDistributionType distributionType, Roaring64NavigableMap expectTaskIds, boolean offHeapEnabled, Optional<PrefetchableClientReadHandler.PrefetchOption> prefetchOption) throws Exception {
        super(appId, shuffleId, partitionId, readBufferSize, expectBlockIds, processBlockIds, distributionType, expectTaskIds, prefetchOption, 4);
        this.filePrefix = filePrefix;
        this.indexReader = this.createHadoopReader(ShuffleStorageUtils.generateIndexFileName(filePrefix), conf);
        this.dataReader = this.createHadoopReader(ShuffleStorageUtils.generateDataFileName(filePrefix), conf);
        this.offHeapEnabled = offHeapEnabled;
    }

    public HadoopShuffleReadHandler(String appId, int shuffleId, int partitionId, String filePrefix, int readBufferSize, Roaring64NavigableMap expectBlockIds, Set<Long> processBlockIds, Configuration conf) throws Exception {
        this(appId, shuffleId, partitionId, filePrefix, readBufferSize, expectBlockIds, processBlockIds, conf, ShuffleDataDistributionType.NORMAL, Roaring64NavigableMap.bitmapOf((long[])new long[0]), false, Optional.empty());
    }

    @Override
    protected ShuffleIndexResult readShuffleIndex() {
        long start = System.currentTimeMillis();
        try {
            ByteBuffer indexData = null;
            indexData = this.offHeapEnabled ? this.indexReader.readAsByteBuffer() : ByteBuffer.wrap(this.indexReader.read());
            int indexDataLength = indexData.limit() - indexData.position();
            int segmentNumber = indexDataLength / 40;
            int expectedLen = segmentNumber * 40;
            if (indexDataLength != expectedLen) {
                LOG.warn("Maybe the index file: {} is being written due to the shuffle-buffer flushing.", (Object)this.filePrefix);
                indexData.limit(expectedLen);
            }
            long dateFileLen = this.getDataFileLen();
            LOG.info("Read index files {}.index for {} ms", (Object)this.filePrefix, (Object)(System.currentTimeMillis() - start));
            return new ShuffleIndexResult(indexData, dateFileLen);
        }
        catch (Exception e) {
            LOG.info("Fail to read index files {}.index", (Object)this.filePrefix, (Object)e);
            return new ShuffleIndexResult();
        }
    }

    @Override
    protected ShuffleDataResult readShuffleData(ShuffleDataSegment shuffleDataSegment, List<ShuffleDataSegment> nextReadSegments) {
        int expectedLength = shuffleDataSegment.getLength();
        if (expectedLength <= 0) {
            LOG.warn("Invalid data segment is {} from file {}.data", (Object)shuffleDataSegment, (Object)this.filePrefix);
            return null;
        }
        ByteBuffer data = this.offHeapEnabled ? this.readShuffleDataByteBuffer(shuffleDataSegment.getOffset(), expectedLength) : ByteBuffer.wrap(this.readShuffleData(shuffleDataSegment.getOffset(), expectedLength));
        int length = data.limit() - data.position();
        if (length == 0) {
            LOG.warn("Fail to read expected[{}] data, actual[{}] and segment is {} from file {}.data", new Object[]{expectedLength, length, shuffleDataSegment, this.filePrefix});
            return null;
        }
        ShuffleDataResult shuffleDataResult = new ShuffleDataResult(data, shuffleDataSegment.getBufferSegments());
        if (shuffleDataResult.isEmpty()) {
            LOG.warn("Shuffle data is empty, expected length {}, data length {}, segment {} in file {}.data", new Object[]{expectedLength, length, shuffleDataSegment, this.filePrefix});
            return null;
        }
        return shuffleDataResult;
    }

    protected byte[] readShuffleData(long offset, int expectedLength) {
        byte[] data = this.dataReader.read(offset, expectedLength);
        if (data.length != expectedLength) {
            LOG.warn("Fail to read expected[{}] data, actual[{}] from file {}.data", new Object[]{expectedLength, data.length, this.filePrefix});
            return new byte[0];
        }
        return data;
    }

    private ByteBuffer readShuffleDataByteBuffer(long offset, int expectedLength) {
        ByteBuffer data = this.dataReader.readAsByteBuffer(offset, expectedLength);
        int length = data.limit() - data.position();
        if (length != expectedLength) {
            LOG.warn("Fail to read byte buffer expected[{}] data, actual[{}] from file {}.data", new Object[]{expectedLength, length, this.filePrefix});
            return ByteBuffer.allocateDirect(0);
        }
        return data;
    }

    private long getDataFileLen() {
        try {
            return this.dataReader.getFileLen();
        }
        catch (IOException ioException) {
            LOG.error("getDataFileLen failed for " + ShuffleStorageUtils.generateDataFileName(this.filePrefix), (Throwable)ioException);
            return -1L;
        }
    }

    @Override
    public synchronized void close() {
        String message;
        try {
            this.dataReader.close();
        }
        catch (IOException ioe) {
            message = "Error happened when close index filer reader for " + this.filePrefix + ".data";
            LOG.warn(message, (Throwable)ioe);
        }
        try {
            this.indexReader.close();
        }
        catch (IOException ioe) {
            message = "Error happened when close data file reader for " + this.filePrefix + ".index";
            LOG.warn(message, (Throwable)ioe);
        }
    }

    protected HadoopFileReader createHadoopReader(String fileName, Configuration hadoopConf) throws Exception {
        Path path = new Path(fileName);
        return new HadoopFileReader(path, hadoopConf);
    }

    public List<ShuffleDataSegment> getShuffleDataSegments() {
        return this.shuffleDataSegments;
    }
}

